function updateSlider(elem)
{
	var value = (elem.value - elem.min)/(elem.max - elem.min);
	
	$(elem).css("background-image", [
		'-webkit-gradient(',
		  'linear, ',
		  'left top, ',
		  'right top, ',
		  'color-stop(' + value + ', rgba(195, 188, 189, 1)), ',
		  'color-stop(' + value + ', transparent)',
		')'	
	].join(''));

	$(elem).next().text($(elem).val());
}

$(function(pe) {
	
	$(document).ready(function(e) {
		if(window.location.hash) {
			$(window.location.hash).show();
			$("#options-back").attr("href", window.location.hash);
		}
		else {
			$('#logo').fadeIn(3000);
			$('#main-menu .button-array').delay(1000).fadeIn(1000);
		}
	});

	$("input[type=range]").change(function(e) {
		updateSlider(this);
	});

	$(".show-prompt").click(function(e) {

		var target = $($(this).attr("href"));
		target.addClass("prompt-visible");

		e.preventDefault();

	});

	$(".hide-prompt").click(function(e) {

		var prompt = $(this).closest(".prompt");
		//prompt.addClass("anim-fadeout").delay(400).removeClass("anim-fadeout").removeClass("prompt-visible");
		prompt.removeClass("prompt-visible");
	});

	$(".navigate-panel").click(function(e) {

		$("#sub-menu").fadeOut(200);
		$("#sub-menu").find(".pane").fadeOut(100);;
		$('.active').removeClass("active");
		$(this).closest(".menu-container").fadeOut(200);
		$($(this).attr("href")).delay(200).fadeIn(200);

		e.preventDefault();

	});

	$(".open-pane").click(function(e) {

		$(this).closest('ul').find('.active').removeClass('active');
		$(this).addClass('active')
		var target = $($(this).attr("data-target-pane"));

		$("#sub-menu").fadeIn(200);
		target.find(".pane").fadeOut(100);
		$($(this).attr("href")).fadeIn(100);

		e.preventDefault();

	});

	// only do these things when we're running the game
	if(typeof util != 'undefined') {

		$(".cvar-slider, .cvar-toggle").change(function(e) {

			// set the cvar if we change the slider
			var cvarValue = $(this).val();
			util.setCvarValue($(this).attr("name"), cvarValue);

			// run any console commands too (if applicable)
			if($(this).is("[data-console-command]"))
				util.consoleCommand($(this).attr("data-console-command"));

		});

		$(".cvar-toggle-apply").change(function(e) {

			var cvarValue = util.getCvarValue($(this).attr("name"));

			if(cvarValue != $(this).attr("value"))
				$(this).closest(".settings-group").addClass("radio-dirty");
			else
				$(this).closest(".settings-group").removeClass("radio-dirty");
		});

		$(".cvar-slider").each(function(i, e) {

			// set to current value
			var cvarValue = parseFloat(util.getCvarValue($(this).attr("name")));

			$(this).val(cvarValue);
			updateSlider(this);

		});

		// handle radio buttons and checkboxes
		$(".cvar-toggle, .cvar-toggle-apply").each(function(i, e) {

			var cvarValue = util.getCvarValue($(this).attr("name"));

			if(cvarValue == $(this).attr("value"))
				$(this).attr("checked", "checked");

		});

		// apply cvars button for video settings
		$(".apply-cvars-button").click(function(e) {

			var target = $($(this).attr("data-target"));

			target.find(".radio-dirty input:checked").each(function(i, elem) {
				// set the cvar if we change the slider
				var cvarValue = $(elem).val();
				util.setCvarValue($(elem).attr("name"), cvarValue);

				// run any console commands too (if applicable)
				if($(elem).is("[data-console-command]"))
					util.consoleCommand($(elem).attr("data-console-command"));				
			});

		});

		// snd quality options
		var dsp_slow_cpu = parseInt(util.getCvarValue("dsp_slow_cpu"));
		var snd_pitchquality = parseInt(util.getCvarValue("snd_pitchquality"));

		var snd_qualty = 0;

		if(!dsp_slow_cpu)
			snd_qualty = 1;

		if(snd_pitchquality)
			snd_qualty = 2;

		$(".snd-quality-toggle[value=" + snd_qualty + "]").click();

		$(".snd-quality-toggle").change(function(e) {

			var new_quality = parseInt($(this).val());

			if(new_quality == 0)
			{
				util.setCvarValue("dsp_slow_cpu", 1);
				util.setCvarValue("snd_pitchquality", 0);
			}
			else if(new_quality == 1)
			{
				util.setCvarValue("dsp_slow_cpu", 0);
				util.setCvarValue("snd_pitchquality", 0);
			}
			else
			{
				util.setCvarValue("dsp_slow_cpu", 0);
				util.setCvarValue("snd_pitchquality", 1);
			}

		});

		// screen resolutions
		var resolutions = util.getScreenResolutionChoices();
		var cur_resolution = util.getScreenResolution();

		// find current res
		for(var i = 0; i < resolutions.length; ++i) {
			var res = resolutions[i];

			var radio = $("<input />").attr("name", "resolution").attr("type", "radio").val(res.wide + " " + res.tall);

			if(res.wide == cur_resolution.wide && res.tall == cur_resolution.tall)
				radio.attr("checked", "checked");

			var label = $("<label />").attr("class", "check-label").text(res.wide + " x " + res.tall).prepend(radio);
			$("#resolutions").append(label);
		}

		// find current display mode
		if(cur_resolution.window) {
			if(cur_resolution.borderless)
				$("#display-borderless").click();
			else
				$("#display-windowed").click();
		}
		else
			$("#display-fullscreen").click();

		// apply resolution button
		$(".apply-resolution").click(function(e) {

			var res = $("input[name=resolution]:checked").val();
			var display = $("input[name=display-mode]:checked").val();

			var current = cur_resolution.wide + " " + cur_resolution.tall + " " + (cur_resolution.window?1:0) + " " + (cur_resolution.borderless?1:0);
			var new_mode = res + " " + display;

			if(current != new_mode)
				util.consoleCommand("mat_setvideomode " + new_mode);
		});
	}

	// handle radio arrays
	$(".radio-array input:not(:checked)").each(function(i, e) {
		var parent = $(e).parent();
		parent.hide(); // you can't do parent stuff in CSS (not even CSS3)
	});

	// radio array navigation links
	$(".radio-array").prepend('<a href="#" class="radio-navigate navigate-back">&lt;</a>').append('<a href="#" class="radio-navigate navigate-forward">&gt;</a>');

	// navigation actions
	$(".radio-array .radio-navigate").click(function(e) {

		var direction = $(this).is(".navigate-forward");
		var current = $(this).parent().find("input:checked").parent(); // current label

		var nextSelection = null;

		if(direction) { // forwards
			nextSelection = current.next("label");

			if(!nextSelection.length)
				nextSelection = current.prevAll("label").last();
		}
		else {
			nextSelection = current.prev("label");

			if(!nextSelection.length)
				nextSelection = current.nextAll("label").last();	
		}

		nextSelection.find("input").click();
		nextSelection.show();
		current.hide();

		e.preventDefault();

	});

});