#include "RenderObjectEntityInstanceData.h"
#include "RenderObject.h"
#include <material.h>
#include <cwMacros.h>
#include <cwmessagebox.h>
#include <Entity.h>
#include <stringhash.h>

extern "C" __declspec(dllexport) bool editAsset(char* file,Entity* en)
{
	auto itr = en->getRenderObjectsItr();
	auto end = en->getRenderObjectsEndItr();
	bool changed = false;
	for(;itr != end; ++itr)
	{
		Material::ExtraUniformData* u = itr->obj->getExtraUniform(CONSTHASH("modelUvRep"));
		if(u)
		{
			if(u->getType() == Material::DataTypes::f1)
			{
				float f = *(float*)u->getData();
				if(f >= 11.5f && f <= 12.05f)
				{
					u->setData(4.0f);
					printf("Changes value on obj!\n",itr->obj->name);
					changed = true;
				}
				
			}
		}
	}
	return changed;
}