#version 330 core


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

in vec3 vertex;
in vec3 normal;
in vec4 tangent;
in vec2 texCoord;

out vec2 fragmentTexCoord;
out vec3 fragmentNormal;
out vec3 lights;
out vec2 hatchCoord;

void main(void)
{
	fragmentTexCoord = texCoord;
	
	gl_Position = projectionMatrix*modelViewMatrix*vec4(vertex,1);
	
	fragmentNormal = (modelViewMatrix*vec4(normal, 0.0)).xyz;
	
	hatchCoord = (gl_Position.xy / gl_Position.w) * 4.0f;
}