#version 330 core

uniform mat4 projectionMatrix;
uniform mat4 MVPMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

in vec3 vertex;
in vec3 normal;
in vec4 tangent;
in vec2 texCoord;

out vec2 fragmentTexCoord;
out vec3 positionOut;
out vec3 position;
out float life;

void main(void)
{
	fragmentTexCoord = texCoord;
	life = tangent.w;

	gl_Position = MVPMatrix*vec4(vertex,1);
	positionOut = (modelViewMatrix*vec4(vertex,1)).xyz;
	
	mat3 invMVP = mat3(MVPMatrix);
	invMVP = inverse(invMVP);
	invMVP = transpose(invMVP);

	position = gl_Position.xyz;

}