#version 330 core

uniform mat4 modelViewprojMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;
uniform vec3 viewPos;

in  vec4    vertex;
in  vec3    normal;
in 	vec2 	texCoord;
out vec2	fragmentTexCoord;
out vec3	normalOut;
out vec4	posOut;
out vec3	eyeDir;
out float	fadeOrtho;

void main(void)
{
	gl_Position = modelViewprojMatrix*vertex;
	vec3 worldPos = (modelMatrix*vertex).xyz;
	eyeDir = worldPos- viewPos;
	//eyeDir = (modelViewMatrix * vertex).xyz;
//	vec3 camSpacePos = normalize((modelViewMatrix * vertex).xyz);
//	vec3 camSpaceNrm = (modelViewMatrix * vec4(normal,0)).xyz;
	fragmentTexCoord = texCoord;
//	fragmentColor.rgb = vec3(1.0,1.0,1.0);
//	fragmentColor.a = clamp(float(pow(abs(dot(camSpacePos,camSpaceNrm)) * softMul,softExp)),0,1);
	
	normalOut = ((modelMatrix * vec4(normal.xyz,0)).xyz);
	//posOutSimple = (modelViewMatrix * vertex).xyz;

	fadeOrtho = dot(normalize(normalOut),normalize(eyeDir));
	
//	depthOut.x = gl_Position.z;
//	depthOut.y = gl_Position.w;
//	depthOut.z = gl_Position.z;
	posOut = gl_Position;
}