#version 330 core

uniform mat4 modelViewprojMatrix;
uniform sampler2D deapth;
uniform sampler2D ZcolorGradient;
uniform float deapthBias;
uniform float sizeMod;
uniform float scale;
uniform float screenScale;
uniform float fadeDist;
uniform float radialFade;
uniform float radialFadePower;
uniform float radialFadeFactor;
uniform float depthGradScale;
uniform vec4 color;

in  vec4    vertex;
in 	vec2 	texCoord;
out vec2 	fragmentTexCoord;
out vec4 	fragmentColor;

void main(void)
{
	gl_Position = modelViewprojMatrix*vertex;
	vec4 center = modelViewprojMatrix*vec4(0,0,0,1);


	vec2 samplePos = (gl_Position.xy /gl_Position.w)*0.5 + 0.5;
	vec2 sampleCenter = (center.xy /center.w)*0.5 + 0.5;
	vec2 delta = samplePos-sampleCenter;
	float a = 0.0f;
	const int nbSamples = 4;

	for(int i = 0; i < nbSamples;++i)
	{
		vec2 uv = sampleCenter + ((delta*(i-1))/nbSamples)*sizeMod;
		float d = texture2D(deapth,uv).r;
		d = d==0?10000.0f:d;
		a += (d)<((center.z+deapthBias)/center.w)?0.0:1.0/nbSamples;
	}
	fragmentTexCoord = texCoord;

	a *= (fadeDist/center.z/center.w)*clamp(pow((1.0f+radialFade-length(center.xy/center.w)-abs(vertex.z*radialFade*0.2f))*radialFadeFactor,radialFadePower),0,1);

	fragmentColor = color*clamp(a,0,1)*color.a * texture2D(ZcolorGradient,vec2(vertex.z*depthGradScale,0.5));

	vec2 xAxis = normalize(center.xy);
	vec2 yAxis;
	yAxis.x = -xAxis.y;
	yAxis.y = xAxis.x;
	gl_Position = center;
	gl_Position.xy -= center.xy*vertex.z*2;
	vec2 newPos = xAxis*vertex.y - vertex.x*yAxis;
	gl_Position.xy += (newPos.xy)*(screenScale * center.z + scale);
	gl_Position.z += vertex.z*0.5f;
	
	
}