#version 330 core

uniform mat4 viewProjection;
uniform vec3 lightDir;
uniform vec3 lightDir2;
uniform float rotation[128];
uniform vec4  plPosRange; // Range stored in w

in vec3 vertex;// vec4(posX,posY,PosZ,NormalRotationinRad)
in vec3 normal;
in vec4 tangent;
in vec2 uv;
in int index;

out vec4 color;
out vec2 texCoord;

out vec3 lightDirPL;
out float distToPL;
out vec3 textureLight;
out vec3 textureLight2;
out vec3 textureEye;
out float vertexIdF;
out float linearDepth;
out vec3   pointLColor;
out vec2 hatchCoord;
out vec3 position;
out vec3 depthOut;

// out float sceneZ;

void main(void)
{
	texCoord = uv;
	
	mat2 rot;
	int vertexId = gl_VertexID/4;
	vertexIdF = float(vertexId);
	rot[0][0] = cos(rotation[vertexId]);
	rot[0][1] = sin(rotation[vertexId]);
	rot[1][0] = rot[0][1];
	rot[1][1] = -rot[0][0];
	
	
	vec3 n = vec3(rot * normal.xy,normal.z);
	vec3 t = vec3(rot * tangent.xy,tangent.z);
	vec3 b = cross(n, t);
	b*= tangent.w;
	
	vec3 light = normalize(lightDir);
	textureLight.x = dot(light, t);
	textureLight.y = dot(light, b);
	textureLight.z = dot(light, n);
	
	light = normalize(lightDir2);
	textureLight2.x = dot(light, t);
	textureLight2.y = dot(light, b);
	textureLight2.z = dot(light, n);

	gl_Position = viewProjection*vec4(vertex.xyz,1.0);
	linearDepth = gl_Position.z;
	
	vec3 eye = normalize(-gl_Position.xyz);
	
	textureEye.x = dot(eye, t);
	textureEye.y = dot(eye, b);
	textureEye.z = dot(eye, n);
	
	distToPL = max((plPosRange.w - distance(plPosRange.xyz, vertex.xyz)) / plPosRange.w,0.0);
	distToPL = pow(distToPL,2);
	
	lightDirPL = abs(normalize(plPosRange.xyz - vertex.xyz));
	lightDirPL.x = dot(lightDirPL, t);
	lightDirPL.y = dot(lightDirPL, b);
	lightDirPL.z = dot(lightDirPL, n);
	
	//vec4 projPos = viewProjection*vec4(vertex.xyz,1.0);

	//sceneZ = projPos.z/projPos.w;
	
	hatchCoord = (gl_Position.xy / gl_Position.w) * 4.0f;
	
	position = gl_Position.xyz;
	
	depthOut.x = gl_Position.z;
	depthOut.y = gl_Position.w;
	depthOut.z = 0;
}
