#version 330 core

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

in vec3 vertex;
in vec3 normal;
in vec2 texCoord;

out vec2 fragmentTexCoord;
out vec3 normalOut;
out vec3 positionOut;
out vec2 screenCoord;
out float distanceOut;
out float Zdepth;
out vec3 position;

 float LinearDepth(in float depth){
  return depth==0?10000.0f:(2.0 * 1.01) / (10000 + 1.01 - depth * (10000 - 1.01));
}

void main(void)
{
	fragmentTexCoord = texCoord;
	
	gl_Position = projectionMatrix * modelViewMatrix *vec4(vertex,1);
	positionOut = -(modelViewMatrix *vec4(vertex,1)).xyz;
	distanceOut = gl_Position.w;
	
	Zdepth = LinearDepth(gl_Position.z/gl_Position.w);
	
	vec4 n = ( modelViewMatrix *vec4(normal, 0.0));
	normalOut = n.xyz;
	normalOut = normalize(normalOut);

	screenCoord = (gl_Position.xy / gl_Position.w)*-0.5 - 0.5;
	
	position = gl_Position.xyz;
}