#version 330 core

uniform mat4 viewMatrix;
uniform mat4 projMatrix;
uniform mat4 modelMatrix;
uniform float vertexOffset;

in  vec4    vertex;
in 	vec2 	texCoord;
out vec2 	fragmentTexCoord;
out vec3	worldRay;

void main(void)
{
	gl_Position = modelMatrix * vec4(vertex.xyz,0);
	gl_Position.y += (modelMatrix * vec4(vertex.xyz,1)).y;
	worldRay = normalize(gl_Position.xyz);
	gl_Position *= 50.0f;
	gl_Position = viewMatrix * vec4(gl_Position.xyz,0);
	
	gl_Position = projMatrix* vec4(gl_Position.xyz,1);
	fragmentTexCoord = texCoord;
}