#version 330 core

uniform mat4 viewMatrix;
uniform mat4 projMatrix;
uniform mat4 modelMatrix;

in  vec4    vertex;
in 	vec2 	texCoord;
out vec2 	fragmentTexCoord;

void main(void)
{
	gl_Position = modelMatrix * vec4(vertex.xyz,0);
	gl_Position.y += (modelMatrix * vec4(0,1,0,1)).y;
	gl_Position *= 50;
	gl_Position = viewMatrix * vec4(gl_Position.xyz,0);
	
	gl_Position = projMatrix* vec4(gl_Position.xyz,1);
	fragmentTexCoord = texCoord;
}