#version 330 core

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;
uniform vec3 viewPos;

uniform mat4x3 boneMatrix[82];

in vec3 vertex;
in vec3 normal;
in vec2 texCoord;
in vec4 boneIndex;
in vec4 boneWeight;

out vec2 fragmentTexCoord;
out vec3 normalOut;
out vec3 positionOut;
out vec2 screenCoord;
out float distanceOut;
out float Zdepth;
out vec3 position;

 float LinearDepth(in float depth){
  return depth==0?10000.0f:(2.0 * 1.01) / (10000 + 1.01 - depth * (10000 - 1.01));
}

void main(void)
{
	fragmentTexCoord = texCoord;
	
	vec3 p = vec3(0,0,0);
	vec3 n = vec3(0,0,0);
	for(int i = 0; i < 4; i++)
	{
		p += vec3(((boneMatrix[int(boneIndex[i])])*vec4(vertex,1.0)).xyz) * boneWeight[i];
		n += vec3(((boneMatrix[int(boneIndex[i])])*vec4(normal, 0.0)).xyz) * boneWeight[i];
	}
	n = normalize(n);
	normalOut = (modelViewMatrix*vec4(n, 0.0)).xyz;

	gl_Position = projectionMatrix*modelViewMatrix*vec4(p,1.0);
	positionOut = (modelViewMatrix*vec4(p,1)).xyz;
	distanceOut = gl_Position.w;
	
	Zdepth = LinearDepth(gl_Position.z/gl_Position.w);
	
	

	screenCoord = (gl_Position.xy / gl_Position.w)*-0.5 - 0.5;
	
	position = gl_Position.xyz;
}