#version 330 core

uniform mat4 projectionMatrix;
uniform mat4 MVPMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;
//uniform vec3 viewPos;

in vec3 vertex;
in vec3 normal;
in vec4 tangent;
in vec2 texCoord;

out vec2 fragmentTexCoord;
out vec3 normalOut;
out vec3 positionOut;
out vec2 screenCoord;
//out vec3 reflecVec;
out vec3 position;

void main(void)
{
	fragmentTexCoord = texCoord;
	
	fragmentTexCoord = texCoord;
	
	gl_Position = MVPMatrix*vec4(vertex,1);
	positionOut = (modelViewMatrix*vec4(vertex,1)).xyz;
	
	mat3 invMVP = mat3(MVPMatrix);
	invMVP = inverse(invMVP);
	invMVP = transpose(invMVP);
	
	//normalOut = (modelViewMatrix*vec4(normal, 0.0)).xyz;
	normalOut = invMVP*normal.xyz;
	normalOut = normalize(normalOut);
	
	vec3 worldPos =  (modelMatrix * vec4(vertex,1)).xyz;
	vec3 worldNormal =  (modelMatrix * vec4(normal, 0.0)).xyz;
	worldNormal = normalize(worldNormal);
	//reflecVec = worldPos - viewPos.xyz;
	//reflecVec -= worldNormal * dot(worldNormal,reflecVec)*2;
	
	position = gl_Position.xyz;
	
	screenCoord = (gl_Position.xy / gl_Position.w)*-0.5 - 0.5;
}