#version 330 core

uniform mat4 modelViewprojMatrix;
uniform mat4 ViewMatrix;
uniform float deapthFade;
uniform float deapthAjust;

in  vec4    vertex;
in 	vec2 	texCoord;
in 	vec4 	tangent;
in  vec3    normal;
out vec2 	fragmentTexCoord;
out vec3 	fragmentNromal;
out vec4	screenCoord;
out float life;
out vec2 coreDeapthAndBias;

void main(void)
{
	life = tangent.w;
	gl_Position = modelViewprojMatrix*vertex;
	fragmentTexCoord = texCoord;
	
	fragmentNromal = (ViewMatrix* vec4(normal,0)).xyz;
	
	coreDeapthAndBias.x = gl_Position.z/gl_Position.w;
	
	const float clipPos = 0.01;
	if(gl_Position.z > clipPos)
	{
		if(gl_Position.z - (deapthAjust*0.5f) < clipPos)
		{
			coreDeapthAndBias.y = (gl_Position.z-clipPos)/(deapthAjust*0.5f);
			gl_Position.z = clipPos;
			gl_Position.w = clamp(gl_Position.w+deapthAjust/100,0,1);
		}
		else
		{
			coreDeapthAndBias.y = (gl_Position.z-clipPos-deapthAjust)/(deapthAjust*2);
			gl_Position.w += deapthAjust/100;
			coreDeapthAndBias.y = 1;
		}
			
		
	}
	else
	{
			coreDeapthAndBias.y = -1;
	}
	
	//gl_Position.z = 0.001;
	coreDeapthAndBias.x = gl_Position.z/gl_Position.w;
	coreDeapthAndBias.y = clamp(coreDeapthAndBias.y,0,1);//*0.5 + 0.5;
	screenCoord = gl_Position;
}