#version 330 core

uniform mat4 modelViewprojMatrix;
uniform mat4 ViewMatrix;

in  vec4    vertex;
in 	vec2 	texCoord;
in 	vec4 	tangent;
in  vec3    normal;
out vec2 	fragmentTexCoord;
out vec3 	fragmentNromal;
out vec2	screenCoord;
out float life;

void main(void)
{
	life = tangent.w;
	gl_Position = modelViewprojMatrix*vertex;
	fragmentTexCoord = texCoord;
	
	screenCoord = (gl_Position.xy / gl_Position.w)*-0.5 - 0.5;
	fragmentNromal = (ViewMatrix* vec4(normal,0)).xyz;
}