#version 330 core

uniform mat4 modelViewprojMatrix;

in  vec4    vertex;
in 	vec2 	texCoord;
in 	vec4 	tangent;
out vec2 	fragmentTexCoord;
out vec2	screenCoord;
out float life;
out vec3 position;
void main(void)
{
	life = tangent.w;
	gl_Position = modelViewprojMatrix*vertex;
	fragmentTexCoord = texCoord;
	
	screenCoord = (gl_Position.xy / gl_Position.w)*-0.5 - 0.5;
	position = gl_Position.xyz;
}