#version 330 core

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform float rotation[128];

in vec3 vertex;
in vec3 normal;
in vec4 tangent;
in vec2 texCoord;

out vec2 fragmentTexCoord;
out vec3 normalOut;
out vec3 tangentOut;
out vec3 btangentOut;
out vec3 positionOut;
out vec3 depthOut;
out float vertexIdF;

void main(void)
{
	fragmentTexCoord = texCoord;
	
	gl_Position = projectionMatrix*modelViewMatrix*vec4(vertex,1);
	positionOut = (modelViewMatrix*vec4(vertex,1)).xyz;
	
	mat2 rot;
	int vertexId = gl_VertexID/4;
	vertexIdF = float(vertexId);
	rot[0][0] = cos(rotation[vertexId]);
	rot[0][1] = sin(rotation[vertexId]);
	rot[1][0] = rot[0][1];
	rot[1][1] = -rot[0][0];
	
	
	vec3 rotNormal = vec3(rot * normal.xy,normal.z);
	vec3 rotTang = vec3(rot * tangent.xy,tangent.z);
	
	normalOut = rotNormal; // (modelViewMatrix*vec4(rotNormal, 0.0)).xyz;	
	tangentOut = rotTang; // (modelViewMatrix*vec4(rotTang.xyz, 0.0)).xyz;
	btangentOut = cross(normalOut, tangentOut);
	// btangentOut*= tangent.w;
	
	// normalOut.xyz = (dot(positionOut.xyz,normalOut.xyz) > 0.0)?-normalOut.xyz:normalOut.xyz; 
	
	depthOut.x = gl_Position.z;
	depthOut.y = gl_Position.w;
	depthOut.z = positionOut.z;
}