#version 330 core

uniform mat4 modelViewprojMatrix;
uniform mat4 viewprojMatrix;
uniform mat4 modelMatrix;

in vec3 vertex;
in vec4 tangent;
in vec2 texCoord;

out vec3 normalOut;
out vec3 depthOut;
out vec2 fragmentTexCoord;
out float life;

void main(void)
{
	normalOut = normalize(vertex.xyz - modelMatrix[3].xyz);
	normalOut = (modelViewprojMatrix*vec4(normalOut.xyz,0)).xyz;
	life = tangent.w;
	gl_Position = modelViewprojMatrix*vec4(vertex,1);
	fragmentTexCoord = texCoord;
	
	depthOut.x = gl_Position.z;
	depthOut.y = gl_Position.w;
	depthOut.z = gl_Position.z;
}