#version 330 core

uniform mat4 modelViewprojMatrix;
uniform mat4 modelViewMatrix;
uniform float softMul;
uniform float softExp;

in  vec4    vertex;
in  vec3    normal;
in 	vec2 	texCoord;
out vec2 	fragmentTexCoord;
out vec4 	fragmentColor;
out vec3 normalOut;
out vec3 depthOut;

void main(void)
{
	gl_Position = modelViewprojMatrix*vertex;
	vec3 camSpacePos = normalize((modelViewMatrix * vertex).xyz);
	vec3 camSpaceNrm = (modelViewMatrix * vec4(normal,0)).xyz;
	fragmentTexCoord = texCoord;
	fragmentColor.rgb = vec3(1.0,1.0,1.0);
	fragmentColor.a = clamp(float(pow(abs(dot(camSpacePos,camSpaceNrm)) * softMul,softExp)),0,1);
	
	normalOut = (modelViewMatrix * vec4(normalize(vertex.xyz),0)).xyz;
	depthOut.x = gl_Position.z;
	depthOut.y = gl_Position.w;
	depthOut.z = gl_Position.z;
}