#version 330 core

uniform mat4 viewProjectionMatrix;
uniform mat4 modelViewMatrix;

uniform vec3 viewPos;
uniform mat4 modelMatrix;
uniform float time;
uniform vec3 windScale;
uniform vec3 windForce;
uniform float windSpeed;
uniform sampler2D windScaleTex;

in vec3 vertex;
in vec3 normal;
in vec4 tangent;
in vec2 texCoord;

out vec2 fragmentTexCoord;
out vec3 normalOut;
out vec3 tangentOut;
out vec3 btangentOut;
out vec3 positionOut;
out vec3 depthOut;
out vec3 reflecVec;

void main(void)
{
	fragmentTexCoord = texCoord;
	
	float influence = texture2D(windScaleTex, texCoord).r;
	
	gl_Position = modelMatrix*vec4(vertex,1);
	vec3 ws = (modelMatrix*vec4(windScale,0)).xyz;
	vec3 wf = (modelMatrix*vec4(windForce,0)).xyz;
	float add = gl_Position.x*ws.x + gl_Position.y*ws.y +gl_Position.z*ws.z;
	gl_Position.xyz += vec3(sin(time*6*windSpeed + gl_Position.x*ws.x+add),cos(time*7*windSpeed+gl_Position.y*ws.y+add),sin(-1 + time*-5*windSpeed + gl_Position.z*ws.z+add))*wf*influence;
	gl_Position = viewProjectionMatrix*gl_Position;
	positionOut = (modelViewMatrix*vec4(vertex,1)).xyz;
	
	normalOut = (modelViewMatrix*vec4(normal, 0.0)).xyz;
	
	
	vec3 worldPos =  (modelMatrix * vec4(vertex,1)).xyz;
	vec3 worldNormal =  (modelMatrix * vec4(normal, 0.0)).xyz;
	worldNormal = normalize(worldNormal);
	reflecVec = worldPos - viewPos.xyz;
	reflecVec -= worldNormal * dot(worldNormal,reflecVec)*2;
	// reflecVec= worldNormal;
	// reflecVec = normalize(reflecVec);
	
	
	tangentOut = (modelViewMatrix*vec4(tangent.xyz, 0.0)).xyz;
	btangentOut = -cross(normalOut, tangentOut);
	btangentOut*= tangent.w;
	
	// normalOut.xyz = (dot(positionOut.xyz,normalOut.xyz) > 0.0)?-normalOut.xyz:normalOut.xyz; 
	
	depthOut.x = gl_Position.z;
	depthOut.y = gl_Position.w;
	depthOut.z = positionOut.z;
}