#version 330 core

uniform mat4 viewProjectionMatrix;
uniform mat4 modelViewMatrix;

uniform vec3 viewPos;
uniform mat4 modelMatrix;
uniform float time;
uniform float windScale;
uniform float windForce;
uniform float radius;
uniform vec3 solid;

in vec3 vertex;
in vec3 normal;
in vec4 tangent;
in vec2 texCoord;

out vec2 fragmentTexCoord;
out vec3 normalOut;
out vec3 tangentOut;
out vec3 btangentOut;
out vec3 positionOut;
out vec3 depthOut;
out vec3 reflecVec;

void main(void)
{
	fragmentTexCoord = texCoord;
	
	float influence = pow(clamp((distance(solid.xyz,vertex.xyz)/radius),0,1),3);
	
	gl_Position = modelMatrix*vec4(vertex,1);
	gl_Position.xyz += vec3(sin(time*6 + gl_Position.x*windScale),cos(time*7+gl_Position.y*windScale),sin(-1 + time*-5 + gl_Position.z*windScale))*influence * windForce;
	gl_Position = viewProjectionMatrix*gl_Position;
	positionOut = (modelViewMatrix*vec4(vertex,1)).xyz;
	
	normalOut = (modelViewMatrix*vec4(normal, 0.0)).xyz;
	
	
	vec3 worldPos =  (modelMatrix * vec4(vertex,1)).xyz;
	vec3 worldNormal =  (modelMatrix * vec4(normal, 0.0)).xyz;
	worldNormal = normalize(worldNormal);
	reflecVec = worldPos - viewPos.xyz;
	reflecVec -= worldNormal * dot(worldNormal,reflecVec)*2;
	// reflecVec= worldNormal;
	// reflecVec = normalize(reflecVec);
	
	
	tangentOut = (modelViewMatrix*vec4(tangent.xyz, 0.0)).xyz;
	btangentOut = -cross(normalOut, tangentOut);
	btangentOut*= tangent.w;
	
	// normalOut.xyz = (dot(positionOut.xyz,normalOut.xyz) > 0.0)?-normalOut.xyz:normalOut.xyz; 
	
	depthOut.x = gl_Position.z;
	depthOut.y = gl_Position.w;
	depthOut.z = positionOut.z;
}