#version 330 core

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform vec3 lightDir;

uniform mat4x3 boneMatrix[82];

in vec3 vertex;
in vec3 normal;
in vec4 tangent;
in vec2 texCoord;
in vec4 boneIndex;
in vec4 boneWeight;

out vec2 fragmentTexCoord;
out vec3 normalOut;
out vec3 tangentOut;
out vec3 btangentOut;
out vec3 positionOut;
out vec3 depthOut;

out vec2 screenCoord;
out float distanceOut;
out vec3 position;

void main(void)
{
	fragmentTexCoord = texCoord;

	
	vec3 p = vec3(0,0,0);
	vec3 n = vec3(0,0,0);
	vec3 t = vec3(0,0,0);
	for(int i = 0; i < 4; i++)
	{
		p += vec3(((boneMatrix[int(boneIndex[i])])*vec4(vertex,1.0)).xyz) * boneWeight[i];
		n += vec3(((boneMatrix[int(boneIndex[i])])*vec4(normal, 0.0)).xyz) * boneWeight[i];
		t += vec3(((boneMatrix[int(boneIndex[i])])*vec4(tangent.xyz, 0.0)).xyz) * boneWeight[i];
	}
	n = normalize(n);
	t = normalize(t);
	normalOut = (modelViewMatrix*vec4(n, 0.0)).xyz;
	tangentOut = (modelViewMatrix*vec4(t, 0.0)).xyz;
	btangentOut = -cross(n, t) * tangent.w;

	gl_Position = projectionMatrix*modelViewMatrix*vec4(p,1.0);
	positionOut = (modelViewMatrix*vec4(p,1)).xyz;
	
	
	depthOut.x = gl_Position.z;
	depthOut.y = gl_Position.w;
	depthOut.z = positionOut.z;
	
	
	screenCoord = (gl_Position.xy / gl_Position.w)*-0.5 - 0.5;
	
	position = gl_Position.xyz;
	distanceOut = gl_Position.w;
	
}