#version 330 core

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform vec3 viewPos;
uniform mat4 modelMatrix;

in vec3 vertex;
in vec3 normal;
in vec2 texCoord;
in vec4 tangent;
in vec2 hatchScale;

out vec2 fragmentTexCoord;
out vec3 normalOut;
out vec3 tangentOut;
out vec3 btangentOut;
out vec3 positionOut;
out vec3 depthOut;
out vec2 fragHatchScale;
out vec3 reflecVec;

void main(void)
{
	fragmentTexCoord = texCoord;
	
	gl_Position = projectionMatrix*modelViewMatrix*vec4(vertex,1);
	positionOut = (modelViewMatrix*vec4(vertex,1)).xyz;
	
	normalOut = (modelViewMatrix*vec4(normal, 0.0)).xyz;
	
	vec3 worldPos =  (modelMatrix * vec4(vertex,1)).xyz;
	vec3 worldNormal =  (modelMatrix * vec4(normal, 0.0)).xyz;
	worldNormal = normalize(worldNormal);
	reflecVec = worldPos - viewPos.xyz;
	reflecVec -= worldNormal * dot(worldNormal,reflecVec)*2;
	
	tangentOut = (modelViewMatrix*vec4(tangent.xyz, 0.0)).xyz;
	btangentOut = -cross(normalOut, tangentOut);
	btangentOut*= tangent.w;
	
	depthOut.x = gl_Position.z;
	depthOut.y = gl_Position.w;
	depthOut.z = positionOut.z;
	
	fragHatchScale = hatchScale;
}