#version 330 core

uniform mat4 modelViewprojMatrix;
uniform float time;
uniform vec3 speedVS;
uniform vec3 frequency;
uniform vec3 strengthVS;

in  vec4    vertex;
in 	vec2 	texCoord;
out vec2 	fragmentTexCoord;


void main(void)
{
	vec4 v;
	v = vertex + vec4(sin(time*speedVS.x + vertex.x*frequency.x),sin(time*speedVS.y+vertex.y*frequency.y),sin((time+1.3)*speedVS.z+vertex.z*frequency.z),0)*vec4(strengthVS.xyz,0);
	gl_Position = modelViewprojMatrix*v;
	fragmentTexCoord = texCoord;
}