#version 330 core

uniform mat4 viewMatrix;
uniform mat4  invPMat;
uniform vec2	VPSize;

in vec2 vertex;

out vec2 fragmentTexCoord;
out vec3 fragmentWorldRay;
out vec2 dsCoords[8];
out vec2 screenTexOffset;

void main(void)
{
	gl_Position.xy = vertex * 2.0 - 1.0;
	gl_Position.z  = 0;
	gl_Position.w  = 1;
	
	fragmentTexCoord = vertex;
	
	fragmentWorldRay = vec3(gl_Position.xy,-1);
	vec4 t;
	t = (invPMat * vec4(fragmentWorldRay.xyz,1));
	fragmentWorldRay = t.xyz;
	fragmentWorldRay = (viewMatrix * vec4(fragmentWorldRay.xyz,0)).xyz;
	
	vec2 halfVP = 0.75f / VPSize;
	// Sample neighbor pixels
	dsCoords[0] = fragmentTexCoord + vec2(-halfVP.x,-halfVP.y);
	dsCoords[1] = fragmentTexCoord + vec2(   0,-halfVP.y);
	dsCoords[2] = fragmentTexCoord + vec2( halfVP.x,-halfVP.y);

	dsCoords[3] = fragmentTexCoord + vec2(-halfVP.x,   0);
	dsCoords[4] = fragmentTexCoord + vec2( halfVP.x,   0);

	dsCoords[5] = fragmentTexCoord + vec2(-halfVP.x, halfVP.y);
	dsCoords[6] = fragmentTexCoord + vec2(   0, halfVP.y);
	dsCoords[7] = fragmentTexCoord + vec2( halfVP.x, halfVP.y);
	
	vec4 centerForward;
	centerForward = (invPMat * vec4(0,0,-1,1));
	centerForward = (viewMatrix * vec4(centerForward.xyz,0));
	vec2 dir = normalize(centerForward.xz);
	screenTexOffset.x = -atan(dir.x,dir.y)*0.4;
	screenTexOffset.y = sin(centerForward.y)*0.4;
}