// generated code by the visual shader editor
// Visual Shader Editor by Havok

/* Inclusion-Tag:hwspanning */

//- GLOBAL DEFINITIONS -\\

//- PERMUTATION MARKER -\\

#include <shaders/ShaderHelpers.inc>

#if defined(PERMUTATION_PointLight)
	#define USE_LIGHT_WS
#endif

#if defined(DEFERRED_RENDERING)
	#define USE_TANGENT
	#undef USE_LIGHT_WS
#endif

#ifdef _VISION_DX10

cbuffer g_GlobalConstantBufferFrame : register (b0)
{
  float4x4 matPJ         : packoffset(c0);   // projection matrix
  float4x4 matEye        : packoffset(c4);   // eye matrix
  float4x4 matInvEye     : packoffset(c8);   // inverse eye matrix

  float4 contextCP : packoffset(c12);
  float4    eyePos          : packoffset(c17);  // eye position
  float4    fogParamVS        : packoffset(c19);  // linear depth fog parameter: near, far, 1/(far-near)
}

cbuffer g_GlobalConstantBufferObject : register (b1)
{
  float4x4  matMV   : packoffset(c0);   // model view matrix
  float4x4  matMVP  : packoffset(c4);   // model view projection matrix
  float4x4  mMW : packoffset(c8);   // model to worldspace matrix
  float4    LightmapScaleOfs : packoffset(c13);  // model UV to lightmap
}

cbuffer g_GlobalConstantBufferUser : register (b2)
{
  float4 LightPos : packoffset(c0);
  #if defined(PERMUTATION_SpotLight) || defined(PERMUTATION_ProjPointLight)
    float4 RefPlaneX : packoffset(c1);
    float4 RefPlaneY : packoffset(c2);
    float4 RefPlaneW : packoffset(c3);
  #endif
}

cbuffer g_GlobalConstantBufferParticles : register (b3)
{
  float4   fadeParams    : packoffset(c0);  // particle fade parameter: near, far, 1/(far-near)
  float4   vSubDivAspect : packoffset(c1);  // particle animation parameter: xy:animsubdiv, y:aspect, w:repetitions 
  float4   vStepTexel    : packoffset(c2);  // particle animation parameter: xy:1/animsubdiv, yw:1/texturesize
  float4   vConfig       : packoffset(c3);  // particle flags: x=animated, y=usernormals, z=distorted, w=z-offset
  float4   vCornerUV     : packoffset(c4);  // Corners: xy:upper left, zw: lower right. E.g. -0.5,-0.5,0.5,0.5
}

#else
  float4x4 matMV         : register(c0);
  float4x4 matPJ         : register(c4);
  float4x4 matMVP        : register(c8);
  float4x4 matEye        : register(c12);
  float4x4 matInvEye     : register(c16);
  float4x4 matM2WS       : register(c20);
  float4 contextCP       : register(c24);
  float3 cameraPosition  : register(c31);   // worldspace camera position

	#ifdef _VISION_PS3
	  float4 LightPos : register(c64);
	  #if defined(PERMUTATION_SpotLight) || defined(PERMUTATION_ProjPointLight)
	    float4 RefPlaneX : register(c66);
	    float4 RefPlaneY : register(c67);
	    float4 RefPlaneW : register(c68);
	  #endif
	#else
	  float4 LightPos;
	  #if defined(PERMUTATION_SpotLight) || defined(PERMUTATION_ProjPointLight)
	    float4 RefPlaneX;
	    float4 RefPlaneY;
	    float4 RefPlaneW;
	  #endif
	#endif

	float4 LightmapScaleOfs : register(c60);
	#ifdef USE_FOGCOORD
	float4 fogParamVS : register(c62);
	#endif
	
  float4 fadeParams      : register(c38);

  // hardware spanning
  float4 vSubDivAspect   : register(c39);
  float4 vStepTexel      : register(c40);
  float4 vConfig         : register(c41);
  float4 vCornerUV       : register(c42);  // Corners: xy:upper left, zw: lower right. E.g. -0.5,-0.5,0.5,0.5

#ifdef _VISION_XENON
  float4 vScreenSpanU    : register(c16); // world matrix
  float4 vScreenSpanV    : register(c17); // world matrix
  float4 vDepth          : register(c18); // world matrix
#endif  
  
#endif

#ifdef DEFERRED_RENDERING
float3 GetVectorInTextureSpace(float3 InVector, float3 Tangent, float3 Normal, float3 BiNormal)
{
  float3 OutVector;

  OutVector.x = dot (Tangent, InVector);
  OutVector.y = -dot (BiNormal, InVector);
  OutVector.z = dot (Normal, InVector);
  return OutVector;
}
#endif

struct VS_IN
{
  float3 MeshPosition : POSITION;

#ifdef _VISION_XENON
  float4 Color    : COLOR0_center;
#else  
  float4 Color    : COLOR;
#endif

  float2 UV0 : TEXCOORD0;
  float4 ObjPosAndSize : TEXCOORD3;
  float3 Distortion    : TEXCOORD4; // x=angle
  float3 RotationAxis  : TEXCOORD5; // Rotation
  float4 AnimFrame     : TEXCOORD6; // x=frame#1, y=frame#2, z=weight  
};

struct VS_OUT                                 
{                           
#ifdef _VISION_DX10
	float4 ProjPos  : SV_Position;
#else
  float4 ProjPos  : POSITION;
#endif

#ifdef USE_COLOR
  float4 Color : COLOR0;
#endif

#if defined( USE_UV0 ) || defined( USE_UV1 )
  float4 UV0AND1 : TEXCOORD0;
#endif

  float3 Normal  : TEXCOORD1;
#ifdef USE_TANGENT
  float3 Tangent : TEXCOORD2;
  float3 BiTangent: TEXCOORD3;
#endif

#ifdef PERMUTATION_SpotLight
  float4 ProjTexCoord : TEXCOORD4;
#endif

#ifdef PERMUTATION_ProjPointLight
  float3 ProjDir : TEXCOORD4;
#endif  

#if defined(USE_FOGCOORD) || defined(USE_WORLD_POSITION) || defined(USE_EYEDIR)
  float4 fogCoordAndWorldPos : TEXCOORD5;
#endif

  float4 ScreenPosition : TEXCOORD6;

#ifdef USE_LIGHT_WS
  float3 LightWS : TEXCOORD7;
#endif

#ifdef DEFERRED_RENDERING
float4 EyeDirAndDepth : TEXCOORD7;
#endif

};                                             

// calculate particle fading value
float GetFadeScalar(float z)
{
  return saturate(1.0-(z-fadeParams.x)*fadeParams.z);
}

// used for geometry rotation:
float3x3 MatrixFromAxisAngle(float3 dir, float fAngle)
{
  float s, c;
  float xx, yy, zz, xy, yz, zx, xs, ys, zs, one_c;

  sincos(fAngle, s,c);

  xx = dir.x * dir.x;
  yy = dir.y * dir.y;
  zz = dir.z * dir.z;
  xy = dir.x * dir.y;
  yz = dir.y * dir.z;
  zx = dir.z * dir.x;
  xs = dir.x * s;
  ys = dir.y * s;
  zs = dir.z * s;
  one_c = 1.0f - c;

  float3x3 m;
  m._m00 = (one_c * xx) + c;
  m._m01 = (one_c * xy) - zs;
  m._m02 = (one_c * zx) + ys;

  m._m10 = (one_c * xy) + zs;
  m._m11 = (one_c * yy) + c;
  m._m12 = (one_c * yz) - xs;
  
  m._m20 = (one_c * zx) - ys;
  m._m21 = (one_c * yz) + xs;
  m._m22 = (one_c * zz) + c;
  return m;
}

#ifndef PARTICLES_CUSTOM_UV_SWIZZLE
  #define SwizzleUV(_in) _in
#endif

// calculate tile UV for given frame index
float2 GetAnimFrameUV(float fFrame, float2 corner)
{
  float2 v1;
  v1.x = modf(fFrame / vSubDivAspect.x, v1.y) * vSubDivAspect.x;
  v1 *= vStepTexel.xy;
  float2 v2 = float2(v1.x+vStepTexel.x-vStepTexel.z, v1.y+vStepTexel.y-vStepTexel.w);
  v1 += vStepTexel.zw;
  float2 res = float2(
    corner.x * v2.x + (1.0f-corner.x) * v1.x,
    corner.y * v2.y + (1.0f-corner.y) * v1.y);
	
  return res;
}

#if defined(_VISION_XENON)
VS_OUT vs_main( int i : INDEX )
#else
VS_OUT vs_main( VS_IN In )
#endif                     
{                                              
  VS_OUT Out = (VS_OUT)0; 

  // setup aliases used in the shader:
  float3 MeshPosition;
  float4 ObjPosAndSize;
  float2 Corner;
  float4 Color;
  float4 Distortion;
  float4 Normal;
  float4 AnimFrame; // x=frame#1, y=frame#2, z=weight
  float4 RotationAxis;
  
  
  #ifdef _VISION_XENON
  
    int iVertexCount = (int)vCornerUV.x;
    int iParticleIndex = (int)( (i+0.5f) / iVertexCount );
    int iGeometryVertexIndex = i - (iParticleIndex * iVertexCount);
    asm
    {
      // Fetch the Mesh Geometry Vertex Data
      vfetch MeshPosition.xyz, iGeometryVertexIndex, position0;
      vfetch Corner.xy, iGeometryVertexIndex, texcoord0;

      // Fetch the Instance/Particle Data 
      vfetch ObjPosAndSize, iParticleIndex, texcoord3;
      vfetch Distortion, iParticleIndex, texcoord4;
      vfetch RotationAxis.xyz, iParticleIndex, texcoord5;
      vfetch AnimFrame, iParticleIndex, texcoord6;
      vfetch Color, iParticleIndex, color0;
      vfetch Normal, iParticleIndex, normal; // TODO: Should normal come from geometry in this case?
    };
  
  #else
  
    MeshPosition = In.MeshPosition;
    ObjPosAndSize = In.ObjPosAndSize;
    Color = In.Color;
    Distortion.xyz = In.Distortion;
    AnimFrame.xyz = In.AnimFrame.xyz;
    Corner = In.UV0;
    RotationAxis.xyz = In.RotationAxis;
  
  #endif

  
  float4 vWorldPos;
  
  float3x3 rotation = MatrixFromAxisAngle(RotationAxis.xyz, Distortion.x);
  vWorldPos.xyz = mul(rotation, MeshPosition) * ObjPosAndSize.w + ObjPosAndSize.xyz;
  vWorldPos.w = 1.0f;

  #if defined( USE_UV0 )
  
  #endif
  
  // Transform Position                        
  Out.ProjPos = mul( matMVP, vWorldPos );
  Out.ScreenPosition = Out.ProjPos;
  Out.ScreenPosition.y = -Out.ScreenPosition.y;
  Out.ScreenPosition.z = GetLinearDepth(mul(matMV, float4(vWorldPos.xyz, 1.0f)).z, contextCP.y);
  
  #if defined( USE_WORLD_POSITION ) || defined( USE_EYEDIR )
    Out.fogCoordAndWorldPos.xyz = vWorldPos.xyz;
  #endif  

#ifdef USE_FOGCOORD
  Out.fogCoordAndWorldPos.w = (Out.ProjPos.z-fogParamVS.x) * fogParamVS.z;
#endif

  #ifdef DEFERRED_RENDERING
  Out.EyeDirAndDepth.w = Out.ScreenPosition.z;
  #endif

  #if defined(USE_UV0)
  
  // Compute TexCoord
  if (vConfig.x > 0.0f)
  {
    Out.UV0AND1.xy = SwizzleUV(GetAnimFrameUV(AnimFrame.x*255.0f + 0.001, Corner));
  }
  else
  {
    Out.UV0AND1.xy = SwizzleUV(Corner.xy * float2(vSubDivAspect.w, 1.0f));
  }
  
  #endif

  
  // fade
  #ifdef USE_COLOR
  Out.Color = Color;
  Out.Color.a *= GetFadeScalar(Out.ProjPos.z);  
  #endif

  return Out;                              
}
