// generated code by the visual shader editor
// Visual Shader Editor by Havok

//- GLOBAL DEFINITIONS -\\

//- PERMUTATION MARKER -\\

#include <shaders/SkinningVS.inc>
#include <shaders/ShaderHelpers.inc>

#if defined(DEFERRED_RENDERING)
	#define USE_TANGENT
	#undef USE_LIGHT_WS
#endif


#if defined(PERMUTATION_PointLight_Shadow) || defined(PERMUTATION_SpotLight_Shadow) || defined(PERMUTATION_ProjPointLight_Shadow) || defined(PERMUTATION_DirectionalLight_Shadow)
	#define USE_SHADOWTEX_LIGHTING
#endif

#ifdef _VISION_DX10

cbuffer g_GlobalConstantBufferFrame : register (b0)
{
  float4 fClipPlanes : packoffset(c12);
  float4    eyePos          : packoffset(c17);  // eye position
  float4    fogParamVS        : packoffset(c19);  // linear depth fog parameter: near, far, 1/(far-near)
}

cbuffer g_GlobalConstantBufferObject : register (b1)
{
  float4x4  mMV   : packoffset(c0);   // model view matrix
  float4x4  mMVP  : packoffset(c4);   // model view projection matrix
  float4x4  mMW : packoffset(c8);   // model to worldspace matrix
  float4    LightmapScaleOfs : packoffset(c13);  // model UV to lightmap
}

cbuffer g_GlobalConstantBufferUser : register (b2)
{
#ifndef PROJECTOR_UV
  float4 LightPos : packoffset(c0);
  #if defined(PERMUTATION_SpotLight) || defined(PERMUTATION_ProjPointLight) || defined(PERMUTATION_SpotLight_Shadow) || defined(PERMUTATION_ProjPointLight_Shadow)
    float4 RefPlaneX : packoffset(c1);
    float4 RefPlaneY : packoffset(c2);
    float4 RefPlaneW : packoffset(c3);
  #endif
#else
  float4 PrimaryColor : packoffset(c0);
  float4 RefPlaneS    : packoffset(c1);
  float4 RefPlaneT    : packoffset(c2);
  float4 RefPlaneQ    : packoffset(c3);
  float4 RefPlaneAtt  : packoffset(c4);
#endif
}

#else

	float4x4 mMV : register(c0);
	float4x4 mMVP : register(c8);
	float4x4 mMW : register(c20);
	float3 eyePos : register(c31);

	float4 fClipPlanes : register(c24);

	#if defined(_VISION_PS3) || defined(_VISION_PSP2)
	
	  #ifndef PROJECTOR_UV
	    float4 LightPos : register(c64);
	  #endif
	  #if defined(PERMUTATION_SpotLight) || defined(PERMUTATION_ProjPointLight) || defined(PERMUTATION_SpotLight_Shadow) || defined(PERMUTATION_ProjPointLight_Shadow)
	    float4 RefPlaneX : register(c66);
	    float4 RefPlaneY : register(c67);
	    float4 RefPlaneW : register(c68);
	  #endif
	#else
	  float4 LightPos;
	  #if defined(PERMUTATION_SpotLight) || defined(PERMUTATION_ProjPointLight) || defined(PERMUTATION_SpotLight_Shadow) || defined(PERMUTATION_ProjPointLight_Shadow)
	    float4 RefPlaneX;
	    float4 RefPlaneY;
	    float4 RefPlaneW;
	  #endif
	#endif

	float4 LightmapScaleOfs : register(c60);
	#ifdef USE_FOGCOORD
	float4 fogParamVS : register(c62);
	#endif
	
#endif

#if defined(PROJECTOR_UV) && !defined(_VISION_DX10)
	#ifdef _VISION_PS3
	  float4 PrimaryColor : register(c64);
	  float4 RefPlaneS    : register(c65);
	  float4 RefPlaneT    : register(c66);
	  float4 RefPlaneQ    : register(c67);
	  float4 RefPlaneAtt  : register(c68);
	#else
	  float4 PrimaryColor;
	  float4 RefPlaneS;
	  float4 RefPlaneT;
	  float4 RefPlaneQ;
	  float4 RefPlaneAtt;
	#endif
#endif

struct VS_IN                   
{           
  float3 ObjPos   : POSITION;
  float3 Normal : NORMAL;
  
  #ifdef USE_COLOR
  float4 Color : COLOR0;
  #endif  
  
  #ifdef USE_UV0
  float2 UV0 : TEXCOORD0;
  #endif
  
  #ifdef USE_UV1
  float2 UV1 : TEXCOORD1;
  #endif

#ifdef USE_TANGENT
  float3 Tangent : TEXCOORD2;
#endif

  SKINNING_VERTEX_STREAMS
};                                           

struct VS_OUT                                 
{                           
#ifdef _VISION_DX10
	float4 ProjPos  : SV_Position;
#else
  float4 ProjPos  : POSITION;
#endif

#if defined(USE_COLOR) || defined(PROJECTOR_UV)
  float4 Color : COLOR0;
#endif

#if defined( USE_UV0 ) || defined( USE_UV1 )
  float4 UV0AND1 : TEXCOORD0;
#endif
  float3 Normal  : TEXCOORD1;
#ifdef USE_TANGENT
  float3 Tangent : TEXCOORD2;
  float3 BiTangent: TEXCOORD3;
#endif

#ifdef PROJECTOR_UV
  float4 UVProjAndAttenuation : TEXCOORD4;
#endif

#if defined(PERMUTATION_SpotLight) || defined(PERMUTATION_SpotLight_Shadow)
  float4 ProjTexCoord : TEXCOORD4;
#endif

#if defined(PERMUTATION_ProjPointLight) || defined(PERMUTATION_ProjPointLight_Shadow)
  float3 ProjDir : TEXCOORD4;
#endif  

#if defined(USE_FOGCOORD) || defined(USE_WORLD_POSITION) || defined(USE_EYEDIR)
  float4 fogCoordAndWorldPos : TEXCOORD5;
#endif

  float4 ScreenPosition : TEXCOORD6;

#if defined(USE_LIGHT_WS)
  float3 LightWS : TEXCOORD7;
#endif

#ifdef DEFERRED_RENDERING
float4 EyeDirAndDepth : TEXCOORD7;
#endif

};                                             

#ifdef USE_SKINNING
VS_OUT vs_main_skinning(VS_IN In)
#else
VS_OUT vs_main( VS_IN In )
#endif
{                                              
  VS_OUT Out = (VS_OUT)0; 

  float3 objectSpaceNormal = In.Normal;
	  
  #ifndef USE_SKINNING
    float4 ObjPos = float4(In.ObjPos, 1.0f);
  #else
	float4 ObjPos;
	PREPARE_SKINNING(In.BoneIndices);
	TRANSFORM_OBJECT_POS(ObjPos, In.ObjPos, In.BoneWeight);
  #endif
	  
  float4 worldPos = float4(mul(mMW, ObjPos).xyz, 1.0);

  #ifdef PROJECTOR_UV
 	Out.Color = PrimaryColor;
	float distq = dot(worldPos, RefPlaneQ);
	float dists = dot(worldPos, RefPlaneS);
	float distt = dot(worldPos, RefPlaneT);
	Out.UVProjAndAttenuation.x = 0.5 * distq + dists;
	Out.UVProjAndAttenuation.y = 0.5 * distq + distt;
	Out.UVProjAndAttenuation.w = distq;
	Out.UVProjAndAttenuation.z = dot(worldPos, RefPlaneAtt); // Attenuation is stored in the z component
  #endif
  
  #if defined( USE_WORLD_POSITION ) || defined( USE_EYEDIR )
    Out.fogCoordAndWorldPos.xyz = worldPos.xyz;
  #endif  
  
  Out.ProjPos = mul(mMVP, float4(ObjPos.xyz, 1.0f));  
  Out.ScreenPosition = Out.ProjPos;
  Out.ScreenPosition.y = -Out.ScreenPosition.y;
  Out.ScreenPosition.z = GetLinearDepth(mul(mMV, float4(ObjPos.xyz, 1.0f)).z, fClipPlanes.y);

#ifdef USE_UV0  
Out.UV0AND1.x = In.UV0.x;
Out.UV0AND1.y = In.UV0.y;
#endif
  
  #ifdef USE_COLOR
  Out.Color = In.Color;
  #endif
  
#ifdef USE_UV1  
Out.UV0AND1.zw = In.UV1.xy * LightmapScaleOfs.xy+LightmapScaleOfs.zw;
#endif

  #ifdef USE_SKINNING
  TRANSFORM_OBJECT_NORMAL(objectSpaceNormal, In.Normal, In.BoneWeight);
  #endif

  //output normal, tangent and bi-tangent in worldspace
  Out.Normal  = normalize( mul((float3x3)mMW , objectSpaceNormal) );
  
#ifdef USE_TANGENT

    float3 Tangent;
    #ifndef USE_SKINNING
    Tangent = In.Tangent;
    #else
    TRANSFORM_OBJECT_TANGENT(Tangent, In.Tangent, In.BoneWeight);
    #endif

  Out.Tangent = normalize(mul((float3x3)mMW, Tangent));
  Out.BiTangent = ComputeBiNormal(Out.Tangent, Out.Normal, GetHandednessCorrection(In.Tangent));
#endif

#ifdef USE_FOGCOORD
  Out.fogCoordAndWorldPos.w = (Out.ProjPos.z-fogParamVS.x) * fogParamVS.z;
#endif

#ifdef USE_LIGHT_WS
  Out.LightWS.xyz = LightPos.xyz - worldPos.xyz;
#endif

  #if defined(PERMUTATION_ProjPointLight) || defined(PERMUTATION_ProjPointLight_Shadow)
    //Out.ProjDir = mul( mLight, Out.LightWS);
    // rather use existing matrix (same for spotlights):
    Out.ProjDir.x = dot(Out.LightWS.xyz,RefPlaneX.xyz);
    Out.ProjDir.y = dot(Out.LightWS.xyz,RefPlaneY.xyz);
    Out.ProjDir.z = dot(Out.LightWS.xyz,RefPlaneW.xyz);
  #endif
  #if defined(PERMUTATION_SpotLight) || defined(PERMUTATION_SpotLight_Shadow)
    //Compute projected texture coordinate
    Out.ProjTexCoord.x = dot(RefPlaneX, worldPos);
    Out.ProjTexCoord.y = dot(RefPlaneY, worldPos);
    Out.ProjTexCoord.z = 0.0f;
    Out.ProjTexCoord.w = dot(RefPlaneW, worldPos);
    float4 bias = Out.ProjTexCoord.w*float4(0.5f, 0.5f, 0.0f, 0.0f);
    Out.ProjTexCoord += bias;
  #endif
  
  #ifdef DEFERRED_RENDERING
  Out.EyeDirAndDepth.xyz = GetVectorInTextureSpace(eyePos-worldPos.xyz, Out.Tangent, Out.Normal, Out.BiTangent);
  Out.EyeDirAndDepth.w = Out.ScreenPosition.z;
  #endif 

  return Out;                              
}
