// generated code by the visual shader editor
// Visual Shader Editor by Havok

//- PERMUTATION MARKER -\\

#include <shaders/VisionCommon.inc>
#include <shaders/ShaderHelpers.inc>

#if defined(PERMUTATION_PointLight_Shadow) || defined(PERMUTATION_SpotLight_Shadow) || defined(PERMUTATION_ProjPointLight_Shadow) || defined(PERMUTATION_DirectionalLight_Shadow)
	#define USE_SHADOWTEX_LIGHTING
#endif

//- GLOBAL DEFINITIONS -\\

#if defined(DEFERRED_RENDERING)
	#define USE_TANGENT
	#undef USE_LIGHT_WS
#endif

#if defined( USE_EYEDIR ) && !defined(USE_WORLD_POSITION)
	#define USE_WORLD_POSITION
#endif

#ifdef _VISION_DX10
	cbuffer g_GlobalConstantBufferUser : register (b2)
	{
	  float4 MaterialParams : packoffset(c0); // x:specular mul, y:specular exp, z=Parallax Scaling, w=Parallax Bias. Same as for Material itself!
	  #ifndef DEFERRED_RENDERING
    float4 LightRadius : packoffset(c1); // x:Radius, y:1/Radius (used for attenuation texture), z:Radius^2(not used), w:1/Radius^2(not used)
    #endif
	  #if defined(PERMUTATION_DirectionalLight_Shadow) || defined(PERMUTATION_DirectionalLight)
        float3 LightDirPS   : packoffset(c3);
    #endif  
    #ifdef USE_SHADOWTEX_LIGHTING
      float2 InvScreenSize : packoffset(c4);
    #endif 	  
	  
    #ifndef DEFERRED_RENDERING
    float4 LightColor : packoffset(c2); // xyz: color with pre-multiplied light multiplier
    #else
    float3 MaterialAmbient : packoffset(c1);
    #endif

    #ifdef DEFERRED_RENDERING
    float  AlphaThreshold : packoffset(c2);
    float  GlobalAmbientMultiplier : packoffset(c3);
	float  gMaterialIndex : packoffset(c4);
    #endif
	
	

    // If you add more vision related constants make sure to adjust
    // the packoffset value in the ShaderGenerator!
    
    //- USER EXPOSED PARAMETERS -\\
	}
	
  cbuffer g_GlobalConstantBufferLightGrid : register (b3)
  {
    float4      Light0           : packoffset(c0);
    float4      Light1           : packoffset(c1);
    float4      Light2           : packoffset(c2);
    float4      Light3           : packoffset(c3);
    float4      Light4           : packoffset(c4);
    float4      Light5           : packoffset(c5);
  }	
  
  cbuffer g_GlobalConstantBufferFrame : register (b0)
  {
    float     gTime : packoffset(c16);
    float4    gCamPos : packoffset(c17);
    float4    gCamDir : packoffset(c18);
    float4    gFogColor     : packoffset(c20);  // linear depth fog color
    float4    gGlobalAmbient : packoffset(c21);
    float4    LightmapMultiplier     : packoffset(c22);  // lightmap multiplier (scalar)
  }  
  
#else

  float4 LightmapMultiplier : register(c0);

  #ifdef USE_FOGCOORD
    float4 gFogColor : register(c1);
  #endif

	float4 Light0 : register(c26);
	float4 Light1 : register(c27);
	float4 Light2 : register(c28);
	float4 Light3 : register(c29);
	float4 Light4 : register(c30);
	float4 Light5 : register(c31);

	float2 gTime : register(c18);
	float4 gCamPos : register(c19);
	float4 gCamDir : register(c20);
	float4 gGlobalAmbient : register(c21);

  #if defined(_VISION_PS3) || defined(_VISION_PSP2)
	  float4 MaterialParams : register(c32);
    #ifndef DEFERRED_RENDERING
  	  float4 LightPos : register(c64);
	    float4 LightColor:register(c33);
	    float4 LightRadius:register(c34);
      float3 LightDirPS  : register(c35);
    #endif
	
		#ifdef USE_SHADOWTEX_LIGHTING
			float2 InvScreenSize : register(c36);
		#endif
	
	#else
	  float4 MaterialParams; // x:specular mul, y:specular exp, z=Parallax Scaling, w=Parallax Bias.
    #ifndef DEFERRED_RENDERING
	    float4 LightPos;
	    float4 LightRadius;    // x:Radius, y:1/Radius (used for attenuation texture), z:Radius^2(not used), w:1/Radius^2(not used)
	    float4 LightColor;     // xyz: color with pre-multiplied light multiplier
	    float3 LightDirPS;
    #endif

		#ifdef USE_SHADOWTEX_LIGHTING
			float2 InvScreenSize;
		#endif
	#endif

	#ifdef DEFERRED_RENDERING
	  float4 AlphaThreshold : register(c34);
	  float  GlobalAmbientMultiplier : register(c35);
	  #undef USE_LIGHT_WS // for security only
	#endif

  #ifdef DEFERRED_RENDERING
    float  gMaterialIndex : register(c36);
    float3 MaterialAmbient : register(c33);
  #endif
  
#endif

// Here are the light functions
#ifdef LIGHTING_FUNCTIONS

	float4 Lighting_LightGrid( float4 DiffuseColor, float3 Normal, float SpecularExponent, float3 SpecularColor, float SpecularMultiplier, float3 AmbientColor, float Opacity, float3 EyeNorm )
	{
		LIGHT_RESULT_SPEC res = GetLightGridSpec_WS(EyeNorm, Normal, 
                                       Light0, Light1, 
                                       Light2, Light3, 
                                       Light4, Light5, 
                                       SpecularExponent);

		float4 result = (res.diffuse + float4(AmbientColor.xyz, 0.0))*DiffuseColor;
	
  #ifdef USE_SPECULAR
	  float4 SpecMul = float4(SpecularColor.rgb, 1.0);
	  SpecMul *= SpecularMultiplier;
	  result += res.specular*SpecMul;
  #endif
		
		result.a = Opacity;
		
		return result;
	}
	
	float4 Lighting_LightGridSimple( float4 DiffuseColor, float3 Normal, float SpecularExponent, float3 SpecularColor, float SpecularMultiplier, float3 AmbientColor, float Opacity, float3 EyeNorm )
	{                          
		float DotProd = max(dot(Normal, Light2.xyz), 0.0);
		float3 diffuse = Light0.xyz + Light1.xyz * DotProd;		
		float4 result = float4(diffuse, 1.0) * DiffuseColor;

  #ifdef USE_SPECULAR
		float SpecProd = GetSpecularIlluminationPoint(EyeNorm + Light2.xyz, Normal, SpecularExponent);
		result += SpecProd * SpecularMultiplier * float4(Light1.xyz * SpecularColor, 1.0);
  #endif

		result.a = Opacity;
		
		return result;
	}
	
	#ifdef PERMUTATION_LightmapDot3
	
	float4 Lighting_LightmapDot3( float4 DiffuseColor, float3 Normal, float SpecularExponent, float3 SpecularColor, float SpecularMultiplier, float3 AmbientColor, float Opacity, float3 EyeDir, float2 LightmapCoord )
	{
		float4 cLightmap1 = vTex2D(Lightmap1, Lightmap1_Sampler, LightmapCoord);
		float4 cLightmap2 = vTex2D(Lightmap2, Lightmap1_Sampler, LightmapCoord);
		float4 cLightmap3 = vTex2D(Lightmap3, Lightmap1_Sampler, LightmapCoord);
		
		LIGHT_RESULT_SPEC difspec = GetLightmapDot3LightingSpec(Normal, cLightmap1, cLightmap2, cLightmap3, EyeDir, SpecularExponent);
		float4 cResColor = (difspec.diffuse * LightmapMultiplier.x + float4(AmbientColor.xyz, 0.0))*DiffuseColor;
		
	#ifdef USE_SPECULAR
	  //modulate the specular lighting (either by color or float)
		float4 SpecMul = float4(SpecularColor.rgb, 1.0);
		SpecMul *= SpecularMultiplier;
		cResColor.rgb += difspec.specular.rgb * SpecMul.rgb;
	#endif
		cResColor.a = Opacity;
		
		return cResColor;
	}
	
	#endif
	
	#if defined(PERMUTATION_PointLight) || defined(PERMUTATION_PointLight_Shadow)
	
	float4 Lighting_PointLight( float4 DiffuseColor, float3 Normal, float SpecularExponent, float3 SpecularColor, float SpecularMultiplier, float3 AmbientColor, float Opacity, float3 LightWS, float3 WorldPosition )
	{
	
		float LightIntR = length(LightWS.xyz) * LightRadius.y;  // dist 0..1 for 0..r. Let the sampler clamp it to [0..1], not the shader		
		float LightInt = vTex2D(AttenTex, AttenTex_Sampler, float2(LightIntR, 0.0)).x; //custom attenuation curve texture
  
		float3 NormLightVec = normalize(LightWS);
		float4 SpecMul = float4(SpecularColor.rgb, 1.0);
		float DotProd = saturate(dot(NormLightVec, Normal));
		
		float4 ResColor = DiffuseColor * LightInt * LightColor * DotProd;
		
	#ifdef USE_SPECULAR
		float SpecProd = GetSpecularIlluminationPoint( normalize(gCamPos-WorldPosition) + NormLightVec, Normal, SpecularExponent);
		SpecProd *= SpecularMultiplier;			
		SpecProd = saturate(SpecProd * LightInt * DotProd);
		ResColor += (SpecMul * SpecProd * float4(LightColor.rgb, 0.0));
	#endif
		
		return float4(ResColor.rgb, Opacity);
	}
	
	#endif	
	
	#if defined(PERMUTATION_SpotLight) || defined(PERMUTATION_SpotLight_Shadow)
	
	float4 Lighting_Spotlight( float4 DiffuseColor, float3 Normal, float SpecularExponent, float3 SpecularColor, float SpecularMultiplier, float3 AmbientColor, float Opacity, float3 EyeDir, float3 LightWS, float4 ProjTexCoord )
	{
		float LightIntR = length(LightWS.xyz) * LightRadius.y;  // dist 0..1 for 0..r. Let the sampler clamp it to [0..1], not the shader
		float LightInt = vTex2D(AttenTex, AttenTex_Sampler, float2(LightIntR, 0.0f)).x; //custom attenuation curve texture
		float4 ProjLightCol = LightColor * vTex2Dproj(ProjTex, ProjTex_Sampler, ProjTexCoord); //2D spotlight projector

		float3 NormLightVec = normalize(LightWS);
		float4 SpecMul = float4(SpecularColor.rgb, 1.0);		   
		float DotProd = saturate(dot(NormLightVec.xyz, Normal));

		float4 ResColor = DiffuseColor * LightInt * ProjLightCol * DotProd;
		
	#ifdef USE_SPECULAR
		float SpecProd = GetSpecularIlluminationPoint(EyeDir + NormLightVec, Normal, SpecularExponent);
		SpecProd *= SpecularMultiplier;
		SpecProd = saturate(SpecProd * LightInt * DotProd);
		ResColor += (SpecMul * SpecProd * float4(ProjLightCol.rgb, 0.0));
	#endif
		ResColor*=saturate(sign(ProjTexCoord.w));
		
		return float4(ResColor.rgb, Opacity);
	}
	
	#endif
	
	#if defined(PERMUTATION_ProjPointLight) || defined(PERMUTATION_ProjPointLight_Shadow)

	float4 Lighting_ProjPointLight( float4 DiffuseColor, float3 Normal, float SpecularExponent, float3 SpecularColor, float SpecularMultiplier, float3 AmbientColor, float Opacity, float3 EyeDir, float3 LightWS, float3 ProjDir )
	{
		float LightIntR = length(LightWS.xyz) * LightRadius.y;  // dist 0..1 for 0..r. Let the sampler clamp it to [0..1], not the shader
		float LightInt = vTex2D(AttenTex, AttenTex_Sampler, float2(LightIntR, 0.0f)).x; //custom attenuation curve texture
		float4 ProjLightCol = LightColor * vTexCUBE(ProjTex, ProjTex_Sampler, ProjDir); // Cubemap projector
		
		float3 NormLightVec = normalize(LightWS);
		float4 SpecMul = float4(SpecularColor.rgb, 1.0);
		float DotProd = saturate(dot(NormLightVec.xyz, Normal));

		float4 ResColor = DiffuseColor * LightInt * ProjLightCol * DotProd;
		
	#ifdef USE_SPECULAR
		float SpecProd = GetSpecularIlluminationPoint(EyeDir + NormLightVec, Normal, SpecularExponent);
		SpecProd *= SpecularMultiplier;
		SpecProd = saturate(SpecProd * LightInt * DotProd);
		ResColor += (SpecMul * SpecProd * float4(LightColor.rgb, 0.0));
	#endif
		
		return float4(ResColor.rgb, Opacity);	
	}
	
	#endif
	
	#if defined(PERMUTATION_DirectionalLight) || defined(PERMUTATION_DirectionalLight_Shadow)
	
	float4 Lighting_DirectionalLight(float4 DiffuseColor, float3 Normal, float SpecularExponent, float3 SpecularColor, float SpecularMultiplier, float3 AmbientColor, float Opacity, float3 EyeDir)
	{
		float3 NormLightVec = -LightDirPS;
		float DotProd = saturate(dot(NormLightVec.xyz, Normal.xyz));
		float4 ResColor = DiffuseColor * LightColor * DotProd;

	#ifdef USE_SPECULAR
		float4 SpecMul = float4(SpecularColor.rgb, 1.0);
		float SpecProd = GetSpecularIlluminationPoint(EyeDir + NormLightVec, Normal, SpecularExponent);
		SpecProd *= SpecularMultiplier;
		SpecProd = saturate(SpecProd * DotProd);
		ResColor += (SpecMul * SpecProd * float4(LightColor.rgb, 0.0));	
	#endif
		
		return float4(ResColor.rgb, Opacity);	
	}
	
	#endif
	
	#ifdef USE_SHADOWTEX_LIGHTING
	
	inline float4 GetShadowTexValue(float4 ScreenPosition)
	{
        float2 ScreenTex = GetScreenTexPos(ScreenPosition, InvScreenSize);
		#ifdef _VISION_XENON
		  // Note: shadow information is only stored in the
		  //   green channel, thus we avoid to overwrite the
		  //   stencil values in EDRAM on xbox360 in case of
		  //   interleaved shadow map rendering
		  return float4(vTex2D(ShadowTex, ShadowTex_Sampler, ScreenTex).yyy, 1.0);
		#else
		  return float4(vTex2D(ShadowTex, ShadowTex_Sampler, ScreenTex).xyz, 1.0);
		#endif		
	}
	
	#endif
	
#endif

#ifdef DEFERRED_RENDERING
#include <shaders/DeferredShadingHelpers.inc>
#endif

struct PS_IN
{
#ifdef _VISION_DX10
  float4 ProjPos  : SV_Position;
#else
  float4 ProjPos  : POSITION;
#endif
  
#if defined(USE_COLOR) || defined(PROJECTOR_UV)
  float4 Color : COLOR0;
#endif
  
#if defined( USE_UV0 ) || defined( USE_UV1 )
  float4 UV0AND1 : TEXCOORD0;
#endif

  float3 Normal  : TEXCOORD1;
#ifdef USE_TANGENT
  float3 Tangent : TEXCOORD2;
  float3 BiTangent: TEXCOORD3;
#endif

#ifdef PROJECTOR_UV
  float4 UVProjAndAttenuation : TEXCOORD4;
#endif

#if defined(PERMUTATION_SpotLight) || defined(PERMUTATION_SpotLight_Shadow)
  float4 ProjTexCoord : TEXCOORD4;
#endif

#if defined(PERMUTATION_ProjPointLight) || defined(PERMUTATION_ProjPointLight_Shadow)
  float3 ProjDir : TEXCOORD4;
#endif  

#if defined(USE_FOGCOORD) || defined(USE_WORLD_POSITION) || defined(USE_EYEDIR)
  float4 fogCoordAndWorldPos : TEXCOORD5;
#endif
  
  float4 ScreenPosition : TEXCOORD6;

#if defined(USE_LIGHT_WS)
  float3 LightWS : TEXCOORD7;
#endif

#ifdef DEFERRED_RENDERING
float4 EyeDirAndDepth : TEXCOORD7;
#endif

};

inline float2 GetScreenTexCoords(PS_IN In)
{
  return (In.ScreenPosition.xy / In.ScreenPosition.w) * 0.5 + 0.5;
}

#ifdef DEFERRED_RENDERING
	PS_OUT ps_main( PS_IN In )
#else
	#ifdef _VISION_DX10
	float4 ps_main( PS_IN In ) : SV_Target
	#else
	float4 ps_main( PS_IN In ) : COLOR
	#endif
#endif
{
 
  #ifdef USE_FOGCOORD
	float FogCoord = In.fogCoordAndWorldPos.w;
  #endif
  
  #ifdef USE_WORLD_POSITION
	float3 WorldPosition = In.fogCoordAndWorldPos.xyz;
  #endif

  #ifdef USE_EYEDIR
    #ifdef DEFERRED_RENDERING
      float3 EyeDir = normalize(In.EyeDirAndDepth.xyz);
    #else
      float3 EyeDir = normalize(gCamPos.xyz - WorldPosition);
    #endif
  #endif
  
  //- PIXEL SHADER -\\

}