
-- *** Fog shader permutation config file *** 
AddPermutationInt ("LAYER_COUNT", 4, 3, 2, 1, 0);

AddPermutationBoolGroup("LAYER0_CUBE", "LAYER0_CYLINDER", "LAYER0_SPHERE");
AddPermutationBoolGroup("LAYER1_CUBE", "LAYER1_CYLINDER", "LAYER1_SPHERE");
AddPermutationBoolGroup("LAYER2_CUBE", "LAYER2_CYLINDER", "LAYER2_SPHERE");
AddPermutationBoolGroup("LAYER3_CUBE", "LAYER3_CYLINDER", "LAYER3_SPHERE");

--   Filtering-Function to remove unnecessary permutations:

function IsPermutationSupported (PermutationValues, Platform)

  -- make sure we don't generate layer permutations above the layer count
  if (PermutationValues["LAYER_COUNT"] < 1) then
    if ((not PermutationValues["LAYER0_CUBE"]) or 
        (not PermutationValues["LAYER1_CUBE"]) or
        (not PermutationValues["LAYER2_CUBE"]) or
        (not PermutationValues["LAYER3_CUBE"])) then
      return false;
    end
  end

  if (PermutationValues["LAYER_COUNT"] < 2) then
    if ((not PermutationValues["LAYER1_CUBE"]) or
        (not PermutationValues["LAYER2_CUBE"]) or
        (not PermutationValues["LAYER3_CUBE"])) then
      return false;
    end
  end
  
  if (PermutationValues["LAYER_COUNT"] < 3) then
    if ((not PermutationValues["LAYER2_CUBE"]) or
        (not PermutationValues["LAYER3_CUBE"])) then
      return false;
    end
  end

  if (PermutationValues["LAYER_COUNT"] < 4) then
    if (not PermutationValues["LAYER3_CUBE"]) then
      return false;
    end
  end

  return true;
end


