-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("victory")
  self:AddTriggerTarget("defeat")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.win = false
    self.def = false
    self.limit = 4
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.p0:AddQuest("S02_GOAL_1","main")
    end    
  end
  
  if self.win then
    td = Timer:GetTimeDiff()
    self.limit = self.limit - td
    
    if self.limit <= 0 then
      Citadels.ForceVictory()
    end
  end
  
  if self.def then
    td = Timer:GetTimeDiff()
    self.limit = self.limit - td
    
    if self.limit <= 0 then
      Citadels.ForceDefeat()
    end
  end  
end

function OnTrigger(self, source, target)
  if target == "victory" then
    self.win = true
  elseif target == "defeat" then
    self.def = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
  end
end
