function OnExpose(self)
	self.someString = "abc"
	self.someNumber = 1234
 -- self.someVector = Vision.hkvVec3(0, 1, 2)
end


-- simple finite state machine
function FSM()
	return 
	{
		states = {},
		state = 'none',
		switch = function(self, newState)
			if self.state == newState then
				Debug:Log('FSM.switch : state already set')
				return
			end
			local oldState = self.state
			local old = self.states[oldState]
			if old and old.leave then
				old:leave(self, newState)
			end
			self.state = newState
			--Debug:Log('FSM.switch : '..newState)
			local new = self.states[self.state]
			if new and new.enter then
				new:enter(self, oldState)
			end
		end,
		frame = function(self)
			local s = self.states[self.state]
			if s and s.frame then
				local dt = Timer:GetTimeDiff()
				s:frame(self, dt)
			end
		end,
		setState = function(self, name, obj)
			self.states[name] = obj
		end
	}
end

function createWaitState(time, nextStateName)
	return 
	{
		waitTime = time,
		nextState=nextStateName,
		enter = function(self, fsm, dt)
			self.timer = self.waitTime
			self.next = self.nextState
		end,
		frame = function(self, fsm, dt)
			self.timer = self.timer - dt
			if self.timer < 0 then
				fsm:switch(self.nextState)
			end
		end
	}
end

function createAttackState(player, unitWildcard, attackGroupSize)
	local s = {}
	s.player = player
	s.unitWildcard = unitWildcard
	s.attackGroupSize = attackGroupSize or 4
	s.gatherRadius = 5000
	
	s.frame = function(self, fsm, dt)
		local player = self.player
		local pos = player:GetPosition()
		
		if pos then
			player:Deselect()
			local n = player:SelectUnitsInRadius(pos, self.gatherRadius, self.unitWildcard)
			
			Renderer.Draw:Box(pos, radius, Vision.V_RGBA_YELLOW)
			
			if n >= self.attackGroupSize then
				player:SetAggressive()
				local numEnemies = player:GetNumEnemies()
				if numEnemies > 0 then
				
					Debug:Log('found '..numEnemies..' enemies')
					local enemy = player:GetEnemy(0)	-- get just first
					
					Debug:Log('moving units to enemy position')
					local enemyPos = enemy:GetPosition()
					player:Move(enemyPos)
					
					local rise = Vision.hkvVec3(0, 0, 200)
					Renderer.Draw:Line(pos+rise, enemyPos+rise, Vision.V_RGBA_RED)
					
					fsm:switch('wait')
					return
				end
			end
		end
		fsm:switch('attackwait')
	end

	return s
end

function SimpleFSM(player)
	local m = FSM()
	m:setState('wait', createWaitState(10, 'attack'))
	m:setState('attack', createAttackState(player, '*peasant*'))
	m:setState('attackwait', createWaitState(1, 'attack'))
	m:switch('wait')
	return m
end

function printVar(name, v)
	Debug:Log('var : ' .. name .. " (" .. tostring(v) .. ")")
end

function printPos(name, v)
	Debug:Log('pos : ' .. name .. " = " .. tostring(v.x) .. "," .. tostring(v.y) .. "," .. tostring(v.z) .. ")")
end

function OnAfterSceneLoaded(self)
	Debug:Log('Player.OnAfterSceneLoaded: begin')
	if self.state then
		Debug:Log('*** duplicate !')
		return
	end
	self.fsm = SimpleFSM(self)
	Debug:Log('Player.OnAfterSceneLoaded: end')
end

function OnThink(self)
	self.fsm:frame()
end


