﻿function OnExpose(self)
	self.someString = "abc"
	self.someNumber = 1234
 -- self.someVector = Vision.hkvVec3(0, 1, 2)
end

function printVar(name, v)
	Debug:Log('var : ' .. name .. " (" .. tostring(v) .. ")")
end

function printPos(name, v)
	Debug:Log('pos : ' .. name .. " = " .. tostring(v.x) .. "," .. tostring(v.y) .. "," .. tostring(v.z) .. ")")
end

function OnAfterSceneLoaded(self)
	Debug:Log('Player.OnAfterSceneLoaded: begin')
	if self.loaded then
		Debug:Log('*** duplicate !')
		return
	end
	self.loaded = true
	Debug:Log('Player.OnAfterSceneLoaded: end')
end

local function player_addEvent(player, waitT, fn)
	table.insert(player.events, {t=waitT,handler=fn})
end

local function think(player)
  if not player.events then
    return
  end
	local dt = Timer:GetTimeDiff()
	if #player.events > 0 then
		local r = player.events[1]
		r.t = r.t - dt
		if r.t <= 0 then
			r.handler(player)
			table.remove(player.events, 1)
		end
	end
end

local function init(player)
	local enemy = player:GetEnemy(0)
	if not enemy then
		return
	end
	local enemyPos = enemy:GetPosition()
	local playerPos = player:GetPosition()

	local rallyPoint = (enemyPos + playerPos) * 0.5

	player.t = 0
	player.events = {}
	player.addEvent = player_addEvent
	
	player:SetPopulationLimit(6)
	
	player:addEvent(120, function()
		player:AttackGroupAdd('unit_L_fman_L1', 5)
		player:AttackGroupAdd('unit_L_archer_L1', 5)
		player:AttackGroupAdd('unit_L_catapult_L1', 1)
		player:AttackGroupCommit(120, rallyPoint,20)
	end)

	player:addEvent(120, function()
		player:AttackGroupAdd('unit_L_fman_L1', 7)
		player:AttackGroupAdd('unit_L_archer_L1', 7)
		player:AttackGroupAdd('unit_L_catapult_L1', 3)
		player:AttackGroupCommit(120, rallyPoint,20)
	end)
	
	player:addEvent(240, function()
		player:AttackGroupAdd('unit_L_fman_L1', 10)
		player:AttackGroupAdd('unit_L_archer_L1', 10)
		player:AttackGroupAdd('unit_L_catapult_L1', 5)
		player:AttackGroupCommit(120, rallyPoint,20)
	end)
	
	player:addEvent(240, function()
		player:AttackGroupAdd('unit_L_fman_L1', 20)
		player:AttackGroupAdd('unit_L_archer_L1', 10)
		player:AttackGroupAdd('unit_L_catapult_L1', 10)
		player:AttackGroupCommit(120, rallyPoint,20)
	end)
	
	local attackers = Game:GetEntity("attackers0")
	if not attackers then
		Debug:Log("ERROR: 'attackers' not found")
		return
	end
	
	local attackersPos = attackers:GetPosition()
	
	-- create aggresive catapults near player townhall
--[[	
	for i=0,4 do
		local name = 'cpm_'..i
		player:Create(attackersPos + Vision.hkvVec3(4000 + i * 300, 0, 0), 'unit_L_catapult_L1', name)
		Debug:Log('unit '..name..' created')
	end
	
	player:Deselect()
	local selCount = player:SelectUnitsByName('cp_*')
	player:SetAggressive()
	player:Move(enemyPos)
	
	Debug:Log('sent '..selCount..' units')
]]--
end

function OnThink(self)
	if not self.init then
		self.init = true
		init(self)
	end
	
	think(self)
end


