local wave_0 = {}
local wave_1 = {}
local mission = {}

local function LoadWaveParams()
  wave_0['unit_D_archer_L1'] = 0.05 * mission.base
  wave_0['unit_D_fman_L1'] = 0.05 * mission.base
  wave_1['unit_D_archer_L1'] = 0.06 * mission.base
  wave_1['unit_D_fman_L1'] = 0.06 * mission.base
end

local function UpdateWaveParams()
  if mission.wave_counter > 3 then
    return
  end
  if mission.wave_counter > 2 then
    wave_0['unit_D_archer_L2'] = nil
    wave_0['unit_D_fman_L2'] = nil
    wave_1['unit_D_archer_L2'] = nil
    wave_1['unit_D_fman_L2'] = nil
    wave_0['unit_D_archer_L3'] = 0.05 * mission.base
    wave_0['unit_D_fman_L3'] = 0.05 * mission.base
    wave_1['unit_D_archer_L3'] = 0.06 * mission.base
    wave_1['unit_D_fman_L3'] = 0.06 * mission.base
    return
  end
  if mission.wave_counter > 1 then
    wave_0['unit_D_archer_L1'] = nil
    wave_0['unit_D_fman_L1'] = nil
    wave_1['unit_D_archer_L1'] = nil
    wave_1['unit_D_fman_L1'] = nil
    wave_0['unit_D_archer_L2'] = 0.05 * mission.base
    wave_0['unit_D_fman_L2'] = 0.05 * mission.base
    wave_1['unit_D_archer_L2'] = 0.06 * mission.base
    wave_1['unit_D_fman_L2'] = 0.06 * mission.base
  end
end

local function SendWave(root_key, wave, spawn, target)
	mission.wave_counter = mission.wave_counter + 1
  --UpdateWaveParams()
	local key = root_key..'_'..mission.wave_counter..'_'
  Debug:Log("Wave Script: Generating wave: "..key)
  for k,v in pairs(wave) do
    for i=1,v,1 do
      local name = key..i
      local unitposition = mission.enemy:GetFreePosition(spawn, 1000, 100)
      mission.enemy:createUnit(unitposition, mission.enemyIndex, 2, k, name)
    end
  end
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName(key..'*')
  mission.enemy:SetAggressive()
  mission.enemy:Move(target)
end

local function GenerateWaves()
  SendWave('wave_0', wave_0, mission.spawn_0, mission.target)
  SendWave('wave_1', wave_1, mission.spawn_1, mission.target)
end

local function init(self)
  Debug:Log('Wave Script: init started')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex) -- my player
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex) -- enemy player
  mission.timer_default = 720 * ( 2 - mission.player:GetDifficultyCoef() )
  mission.timer_init_default = 600
  if not self.load then
	mission.timer =  mission.timer_init_default
	mission.wave_counter = 0
  end
  mission.base = 100 * mission.player:GetDifficultyCoef()
  mission.spawn_0 = Game:GetEntity('SpawnPosition_0'):GetPosition()
  mission.spawn_1 = Game:GetEntity('SpawnPosition_1'):GetPosition()
  mission.target = Game:GetEntity('AttackPosition'):GetPosition()
	LoadWaveParams()
  self.init_done = true
  Debug:Log('Wave Script: init finished')
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end

  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    if not G.stop_waves then GenerateWaves() end
    mission.timer = mission.timer_default
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
     mission.wave_counter = ar:Read()
	   mission.timer = ar:Read()
     Debug:Log('Script Load End')
	 self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(mission.wave_counter)
     ar:Write(mission.timer)
     Debug:Log('Script Save End')
   end
end


