--[[
this script will check if player build desired army size
(see mission desing) and then send attack wave to attack target
position
]]--

local mission = {}
local army = {}
local attack1 = {}
local attack2 = {}
local attack3 = {}
local save_thinks = {}
local save_thinkCounter = 1


local function LoadArmyParams()
  army['unit_L_archer_L3'] = 15  --longbowman
  army['unit_L_fman_L3'] = 15 -- footknight
  army['unit_L_rider_L2'] = 10  -- grail knight
  army['unit_L_catapult_L2'] = 5 -- siege catapult
  army['unit_L_trebuchet_base_L1'] = 1 -- trebuche
end

-- its not used now
-- all units are already in scene
local function LoadAttackParams()
  attack1['unit_D_archer_L3'] = 0.15 * mission.base
  attack1['unit_D_fman_L3'] = 0.15 * mission.base
  attack2['unit_D_rider_L2'] = 0.05 * mission.base
  attack3['unit_D_catapult_L1'] = 0.05 * mission.base
end

local function SendWavePosition(root_key, wave, spawn)
  for k,v in pairs(wave) do
    for i=1,v,1 do
      local name = root_key..i
      local unitposition = mission.enemy:GetFreePosition(spawn, 2000, 100)
      mission.enemy:createUnit(unitposition, mission.enemyIndex, 2, k, name)
    end
  end
end

local function SendWave(root_key, target)
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName(root_key..'*')
  mission.enemy:SetAggressive()
  mission.enemy:Move(Game:GetEntity('Meeting'):GetPosition(), 450)
end

local function CheckFinalBattle()
  local c =  mission.enemy:CheckUnitsCountKey('attack_wave_*', 8, mission.enemyIndex)
  if not c then
    -- change ownership of last x units
    mission.player:WinQuest('M09_Attack')
    --mission.enemy:Deselect()
    --mission.enemy:SelectUnitsByName('attack_wave_*')
    --mission.enemy:SetDefensive()
    --mission.enemy:SetOwnership(mission.playerIndex)
    Debug:Log('Mission Script: Victory!!!')
	mission.player:UnlockCharacter("L_Sir-Gavain")
	Citadels.SetAchievementDone(6)
    Citadels.ForceVictory()
  end
end

local function CheckArmySize()
  local result = true
  for k,v in pairs(army) do
    -- check number of combat units
    result = result and mission.player:CheckUnitsCountPrefab(k, v, mission.playerIndex)
  end
  if not result then
    return
  end
  -- if ok, send last attack wave
  --SendWavePosition('attack_wave_', attack1, mission.spawnI)
  --SendWavePosition('attack_wave_', attack2, mission.spawnR)
  --SendWavePosition('attack_wave_', attack3, mission.spawnC)
  SendWave('attack_wave_', mission.target)
  local m1 = 'Prepare for final battle!'
  local m2 = 'You have 15 minutes to success or fall into forgotten history.'
  --mission.player:PrintInfoMessage(m1)
  --mission.player:PrintInfoMessage(m2)
  Debug:Log("Wave Script: Prepare for final battle")
  Debug:Log("Wave Script: You have 10 minutes to win !!!")
  G.stop_waves = true
  mission.last_attack = true
  mission.timer_default = 15 -- each 15s
  mission.player:WinQuest('M09_Army')
  mission.player:AddQuest('M09_Attack', 'main')
  save_thinkCounter = 2
  mission.thinkFunction = CheckFinalBattle
end

local function init(self)
  Debug:Log('Main Script: Init Start')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex) -- my player
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex) -- enemy player
  mission.enemy:SetPopulationLimit(130)
  mission.timer_default = 2
  mission.timer =  mission.timer_default
  mission.spawnC = Game:GetEntity('CatapultsSpawn'):GetPosition()
  mission.spawnR = Game:GetEntity('RidersSpawn'):GetPosition()
  mission.spawnI = Game:GetEntity('InfantrySpawn'):GetPosition()
  mission.target = Game:GetEntity('AttackPosition'):GetPosition()
  mission.base = 75 * mission.player:GetDifficultyCoef()
  if not self.load then
	  Debug:Log('You should not see this when load game')
    mission.last_attack = false
	  mission.last_attack_timer = 1200
	  save_thinkCounter = 1
	  mission.thinkFunction = CheckArmySize
	  mission.player:AddQuest('M09_Army', 'main')
  end
  LoadArmyParams()
  LoadAttackParams()
  self.init_done = true
  Debug:Log('Main Script: Init End')
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt

  if mission.timer <= 0 then
    mission.thinkFunction()
    mission.timer = mission.timer_default
  end

  if mission.last_attack then
	  mission.last_attack_timer = mission.last_attack_timer - dt
	  if mission.last_attack_timer <= 0 then
			local m1 = 'Timer Out ! You have lost.'
			mission.player:PrintInfoMessage(m1)
			Debug:Log('Main Script: Timer Out !!!')
			Debug:Log('Main Script: Defeat!!!')
			mission.last_attack = false
			Citadels.ForceDefeat()
	  end
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
	 mission.last_attack = ar:Read()
	 mission.last_attack_timer = ar:Read()
	 --Debug:Log(mission.last_attack_timer)
	 save_thinkCounter = ar:Read()
	 --Debug:Log(save_thinkCounter)
	 save_thinks[1] = CheckArmySize
	 save_thinks[2] = CheckFinalBattle
	 mission.thinkFunction = save_thinks[save_thinkCounter]
        G.stop_waves = ar:Read()
     Debug:Log('Script Load End')
	 self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(mission.last_attack)
	  ar:Write(mission.last_attack_timer)
	  --Debug:Log(mission.last_attack_timer)
	  ar:Write(save_thinkCounter)
	  --Debug:Log(save_thinkCounter)
         ar:Write(G.stop_waves)
     Debug:Log('Script Save End')
   end
end
