--[[
script checks if player did destroy enemy's townhall
after then he start sending waves from 3 distinctive spawnpoints
]]--

local wave_1 = {}
local wave_2 = {}
local wave_3 = {}
local mission = {}
local save_thinks = {}
local save_thinkCounter = 1

local function LoadWaveParams()
  wave_1['unit_D_archer_L3'] = 0.15 * mission.base
  wave_1['unit_D_catapult_L2'] = 0.10 * mission.base
  wave_2['unit_D_archer_L3'] = 0.15 * mission.base
  wave_2['unit_D_fman_L3'] = 0.20 * mission.base
  wave_3['unit_D_archer_L3'] = 0.10 * mission.base
  wave_3['unit_D_fman_L3'] = 0.20 * mission.base
  wave_3['unit_D_catapult_L2'] = 0.05 * mission.base
  wave_3['unit_D_rider_L2'] = 0.10 * mission.base
end

local function LoadPositions()
  mission.waves_spawn[1] = Game:GetEntity('SpawnPosition0'):GetPosition()
  mission.waves_spawn[2] = Game:GetEntity('SpawnPosition1'):GetPosition()
  mission.waves_spawn[3] = Game:GetEntity('SpawnPosition2'):GetPosition()
  mission.waves_attack[1] = Game:GetEntity('AttackPosition0'):GetPosition()
  mission.waves_attack[2] = Game:GetEntity('AttackPosition1'):GetPosition()
  mission.waves_attack[3] = Game:GetEntity('AttackPosition2'):GetPosition()
end

local function SendWave()
  mission.wave_counter = mission.wave_counter + 1
  local key = mission.waves_root_key..mission.wave_counter..'_'
  local r = math.random(1,3)
  Debug:Log("Waves script: Generating wave: "..key)
  local w = mission.waves[mission.wave_counter]
  for k,v in pairs(w) do
    for i=1,v,1 do
      local name = key..i
      local unitposition = mission.enemy:GetFreePosition(mission.waves_spawn[r], 1000, 100)
      mission.enemy:createUnit(unitposition, mission.enemyIndex, 2, k, name)
    end
  end
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName(key..'*')
  mission.enemy:SetAggressive()
  mission.enemy:Move(mission.target, 350)
  mission.thinkFunction = CheckAttackWaveStatus
end

local function SwitchOwnership()
	Debug:Log('Waves Script: Changing fortification ownership')
  mission.ownership_radius = 7200
	mission.enemy:SwitchOwnershipInRadius(mission.ownership_position, mission.ownership_radius, mission.enemyIndex, mission.playerIndex)
end

local function SendUnitsHome(key)
	mission.enemy:Deselect()
	mission.enemy:SelectUnitsByName(key)
	mission.enemy:SetDefensive()
	mission.enemy:Move(mission.waves_spawn[2])
end

local function CheckDefeatCondition()
-- bld_D_barracks_L3
-- bld_D_arrange_L3
local b = mission.player:BuildingBuilt('bld_D_barracks_L3')
local a = mission.player:BuildingBuilt('bld_D_arrange_L3')
if not a and not b then
  Citadels.ForceDefeat()
end
end

function CheckAttackWaveStatus()
  CheckDefeatCondition()
  local key = mission.waves_root_key..mission.wave_counter..'_*'
  local c =  mission.enemy:CheckUnitsCountKey(key, 7, mission.enemyIndex)
  Debug:Log('Checking wave...')
  if not c  then
    if mission.wave_counter == 3 then
      -- this was last wave generated, u have won!!!
      mission.player:WinQuest('M08_Infiltration')
	  SendUnitsHome(key)
	  if G.quest1_done and G.quest2_done then
		mission.player:UnlockCharacter("L_Sir-Tristan")
	  end
      Debug:Log('You have won the mission!')
	  Citadels.SetAchievementDone(5)
      Citadels.ForceVictory()
      mission.thinkFunction = function() end
    end
	SendWave()
  end
end

local function CheckTownhallDestroyed()
  --check if army lives
  if not mission.player:UnitGroupLives('starting_unit') then
      mission.player:FailQuest('M8G_GOAL_2')
      Citadels.ForceDefeat()
  end
  --check all units dead
  local c = mission.enemy:UnitGroupLives('deff_units_town')
  if not c then
	mission.player:WinQuest('M8G_GOAL_2')
	
	SwitchOwnership()
    mission.player:AddQuest('M08_Infiltration', 'main')
    SendWave()
	save_thinkCounter = 2
    mission.thinkFunction = CheckAttackWaveStatus
	
  end
  --[[
  --check if townhall lives
  local ent = Game:GetEntity('EnemyTownhall')
  if not ent then
	mission.player:WinQuest('M08_G_Castle')
  end
  if not ent and not c then
    SwitchOwnership()
    mission.player:AddQuest('M08_Infiltration', 'main')
    SendWave()
	save_thinkCounter = 2
    mission.thinkFunction = CheckAttackWaveStatus
  end
  ]]--
end

local function init(self)
  Debug:Log('Waves Script: Init Started')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex) -- my player
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex) -- enemy player
  mission.target = Game:GetEntity('AttackPosition'):GetPosition()
  mission.timer_default = 4
  mission.base = 60 * mission.player:GetDifficultyCoef()
  mission.position = Game:GetEntity('Position'):GetPosition()
  mission.rad = 5700
  mission.timer = mission.timer_default
  if not self.load then
	mission.wave_counter = 0
	--mission.player:AddQuest('M08_G_Castle', 'main')
	--mission.player:SetQuestPosition('M08_G_Castle', 5343,-2293)
	mission.player:AddQuest('M8G_GOAL_2', 'main')
	mission.player:SetQuestPosition('M8G_GOAL_2', 5343,-2293)
    save_thinkCounter = 1
	mission.thinkFunction = CheckTownhallDestroyed
  end
  mission.waves = {wave_1, wave_2, wave_3}
  mission.waves_root_key = 'wave_'
  mission.waves_spawn = {}
  mission.waves_attack = {}
  mission.ownership_position = Game:GetEntity('SwitchOwnershipEntity'):GetPosition()
  LoadWaveParams()
  LoadPositions()
  self.init_done = true
  Debug:Log('Waves Script: Init Finished')
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    mission.thinkFunction()
    mission.timer = mission.timer_default
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
	 mission.script_done = ar:Read()
     mission.wave_counter = ar:Read()
	 save_thinkCounter = ar:Read()
	 save_thinks[1] = CheckTownhallDestroyed
	 save_thinks[2] = CheckAttackWaveStatus
	 mission.thinkFunction = save_thinks[save_thinkCounter]
     Debug:Log('Script Load End')
	  self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(mission.script_done)
     ar:Write(mission.wave_counter)
     ar:Write(save_thinkCounter)
     Debug:Log('Script Save End')
   end
end
