--[[
check status of the side quests
]]--

local quest1 = {}
local quest2 = {}
local mission = {}

local function LoadQuestParams()
  local ent1 = Game:GetEntity('quest1_position')
  local ent2 = Game:GetEntity('quest2_position')
  if not ent1 or not ent2 then
    Debug:Log('Cannot find quest1_position or quest2_position')
    return
  end
  quest1.position = ent1:GetPosition()
  quest2.position = ent2:GetPosition()
  quest1.radius = 700
  quest2.radius = 700
end

local function RewardQuest1()
  mission.player:AddResource(4, 400)
end

local function RewardQuest2()
  mission.player:AddResource(3, 400)
end

local function CheckQuest1()
  if mission.player:SomeUnitsInRadius(quest1.position, quest1.radius, '*') then
    Debug:Log('Quest 1 Finished. Enjoy your reward.')
    G.quest1_done = true
    RewardQuest1()
  end
end

local function CheckQuest2()
  if mission.player:SomeUnitsInRadius(quest2.position, quest2.radius, '*') then
    Debug:Log('Quest 2 Finished. Enjoy your reward.')  
    G.quest2_done = true
    RewardQuest2()
  end
end

local function CheckQuests()
  if not G.quest1_done then
    CheckQuest1()
  end
  if not G.quest2_done then
    CheckQuest2()
  end
end

local function init(self)
  Debug:Log('SideQuests Script: Init Started')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex) -- my player
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex) -- enemy player
  if not self.load then
	G.quest1_done = false
	G.quest2_done = false
	mission.timer_default = 3
  end
  mission.timer = mission.timer_default
  mission.quest1radius = 700
  mission.quest1radius = 700
  LoadQuestParams()
  self.init_done = true
  Debug:Log('SideQuests Script: Init Finished')
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    CheckQuests()
    mission.timer = mission.timer_default
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
	 G.quest1_done = ar:Read()
	 G.quest2_done = ar:Read()
	 mission.timer = ar:Read()
     Debug:Log('Script Load End')
	 self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(G.quest1_done)
     ar:Write(G.quest2_done)
     ar:Write(G.mission.timer)
     Debug:Log('Script Save End')
   end
end
