local mission = {}
local wave = {}
local meeting_points = {}

local function LoadWaveMeetingPoints()
  meeting_points[1] = Game:GetEntity('WaveMeeting1'):GetPosition()
  meeting_points[2] = Game:GetEntity('WaveMeeting2'):GetPosition()
end

local function UpdateWaveParams()
  if mission.wave_generated > 4 then
    wave['unit_L_fman_L1'] = 0.05 * mission.base
    wave['unit_L_archer_L1'] = 0.05 * mission.base
    wave['unit_L_catapult_L1'] = 0.03 * mission.base
    return
  end
  if mission.wave_generated > 10 then
    wave['unit_L_fman_L1'] = 0.1 * mission.base
    wave['unit_L_archer_L1'] = 0.1 * mission.base
    wave['unit_L_catapult_L1'] = 0.05 * mission.base
    return
  end
    if mission.wave_generated > 20 then
    wave['unit_L_fman_L1'] = 0.2 * mission.base
    wave['unit_L_archer_L1'] = 0.2 * mission.base
    wave['unit_L_catapult_L1'] = 0.05 * mission.base
    return
  end
end

local function LoadWaveParams()
  wave['unit_L_fman_L1'] = 0.03 * mission.base
  wave['unit_L_archer_L2'] = 0.03 * mission.base
  wave['unit_L_catapult_L1'] = 0.01 * mission.base
end

local function SentToRandomMeetingPoint()
  local r = math.random(1,2)
  --Debug:Log('Random meeting point is: '..r)
  if r == 1 then
		mission.enemy:Move(meeting_points[1])
	else
		mission.enemy:Move(meeting_points[2])
  end
end

local function GenerateWave()
  mission.wave_generated = mission.wave_generated + 1
  --if mission.wave_generated > 6 then
   --return
  --end
  --UpdateWaveParams()
  for k,v in pairs(wave) do
    for i=1,v,1 do
      local name = string.format("wave%.0f_%.0f", mission.wave_generated, i)
      local unitposition = mission.enemy:GetFreePosition(mission.spawn_position, 1000, 100)
      mission.enemy:createUnit(unitposition, mission.enemyIndex, 2, k, name)
    end
  end
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName(string.format("wave%.0f_*", mission.wave_generated))
  mission.enemy:SetAggressive()
  --mission.enemy:ActionMoveSelectedUnits(mission.mytownhallattackposition)
  SentToRandomMeetingPoint()
  ---mission.enemy:Move(mission.mytownhallattackposition)
end

function init(self)
  Debug:Enable(true)
  Debug:Log('Waves Script: Init Started')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex) -- my player
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex) -- enemy player
  mission.timer_default = 120 * ( 2 - mission.player:GetDifficultyCoef() )
  mission.meeting_radius = 1000
  mission.spawn_ent = Game:GetEntity('WavesSpawnPosition')
  mission.mytownhall = Game:GetEntity('MyTownhall')
  mission.mytownhallattack = Game:GetEntity('MyTownhallAttackPosition')
  mission.spawn_position = mission.spawn_ent:GetPosition()
  mission.mytownhallattackposition = mission.mytownhallattack:GetPosition()
  mission.base = 100 * mission.player:GetDifficultyCoef()
  if not self.load then
	mission.timer = 400
	mission.wave_generated = 0
	G.castle_destroyed = false
	end
  LoadWaveParams()
  LoadWaveMeetingPoints()
  math.randomseed(os.time())
  mission.player:AddQuest('M07_Artifact', 'main')
  mission.player:AddQuest('M07_Castle', 'side')
  mission.player:SetQuestPosition('M07_Castle', -3872,15707)
  Debug:Log('Waves Script: Init Finished')
  self.init_done = true
end

local function CheckWaveOnMeetingPoint()
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsInRadiusOnlyKeyMask(meeting_points[1], mission.meeting_radius, 'wave*')
  mission.enemy:SelectUnitsInRadiusOnlyKeyMask(meeting_points[2], mission.meeting_radius, 'wave*')
  mission.enemy:SelectUnitsInRadiusOnlyKeyMask(meeting_points[3], mission.meeting_radius, 'wave*')
  mission.enemy:Move(mission.mytownhallattackposition)
end

local function ThinkFunction()
  GenerateWave()
  --CheckWaveOnMeetingPoint()
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    ThinkFunction()
    mission.timer = mission.timer_default
  end
end

function OnBeforeDeath(self)
  G.castle_destroyed = true
  mission.player:WinQuest('M07_Castle')
  mission.player:UnlockCharacter("L_Sir-Galahad")
  if G.artifact_done then
	--Citadels.SetAchievementDone(4)
    --Citadels.ForceVictory()
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
     mission.wave_generated = ar:Read()
	 mission.timer = ar:Read()
     Debug:Log('Script Load End')
	  self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(mission.wave_generated)
     ar:Write(mission.timer)
     Debug:Log('Script Save End')
   end
end

