local mission = {}

function init(self)
  Debug:Log('Waves Meeting Script: Init Started')
  mission.timer_default = 3
  mission.timer = mission.timer_default
  mission.enemy = Citadels.GetPlayer(1)
  mission.position = self:GetPosition()
  mission.radius = 1000
  self.init_done = true
end

function ThinkFunction(self)
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsInRadiusOnlyKeyMask(mission.position, mission.radius, 'wave*')
  --mission.enemy:AttackMoveSelectedUnitsObject(Game:GetEntity('WaveAttackPosition1'):GetPosition(), 450)
  mission.enemy:Move(Game:GetEntity('WaveAttackPosition1'):GetPosition(), 450)
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    ThinkFunction(self)
    mission.timer = mission.timer_default
  end
end
