local mission = {}

function OnBeforeDeath(self)
  player0:FailQuest('M07_Artifact')
  Citadels.ForceDefeat()
end

local function ThinkFunction()
  --[[player0 = Citadels.GetPlayer(0)
  local d = player0:InDistance(merlin, townhall, mission.radius)
  if d and G.artifact_taken then
    G.artifact_done = true
    player0:WinQuest('M07_Artifact')
    if G.castle_destroyed then
		player0:UnlockCharacter("L_Sir-Galahad")
    end
	Citadels.SetAchievementDone(4)
	Citadels.ForceVictory()
  end]]--
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    player0 = Citadels.GetPlayer(0)
    townhall = Game:GetEntity('MyTownhall')
    merlin = Game:GetEntity('Merlin')
    mission.radius = 2000
	mission.timer_default = 2
	mission.timer = mission.timer_default
	player0:SetUnitNameToUnit(Game:GetEntity('merlin'), 'unit_L_sirgalahad_L1')
	if not self.load then
		G.artifact_taken = false
		G.artifact_done = false
	end
	self.init_done = true
  end
  if G.artifact_done then return end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    ThinkFunction()
    mission.timer = mission.timer_default
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
     G.castle_destroyed = ar:Read()
	 G.artifact_done = ar:Read()
	 G.artifact_taken = ar:Read()
	 mission.timer = ar:Read()
	 self.init_done = ar:Read()
     Debug:Log('Script Load End')
	  self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(G.castle_destroyed)
     ar:Write(G.artifact_done)
     ar:Write(G.artifact_taken)
	 ar:Write(mission.timer)
	 ar:Write(self.init_done)
     Debug:Log('Script Save End')
   end
end

