mission = {}
big_wave1 = {}
big_wave2 = {}
big_wave1_path = {}
big_wave2_path = {}

local function LoadBigWaveParams()
  big_wave1['unit_L_fman_L2'] = 0.10 * mission.base
  big_wave1['unit_L_archer_L2'] = 0.10 * mission.base
  big_wave2['unit_L_catapult_L2'] = 0.03 * mission.base
  big_wave2['unit_L_fman_L2'] = 0.07 * mission.base
  big_wave2['unit_L_archer_L2'] = 0.07 * mission.base
  big_wave2['unit_L_catapult_L2'] = 0.10 * mission.base
end

local function LoadPathParams()
  -- wave no. 1
  for i=1,6,1 do
    local nod_name = string.format("BigWavePart1Node%.0f", i)
    local nod = Game:GetEntity(nod_name)
    if not nod then
      Debug:Log('Cannot find node: '..nod_name)
      return
    end
    big_wave1_path[i] = nod:GetPosition()
  end
  -- wave no. 2
  for i=1,4,1 do
    nod_name = string.format("BigWavePart2Node%.0f", i)
    nod = Game:GetEntity(nod_name)
    if not nod then
      Debug:Log('Cannot find node: '..nod_name)
      return
    end
    big_wave2_path[i] = nod:GetPosition()
  end
end

local function SendBigWaveToMeeting()
  Debug:Log('Going to sent big wave')
  --sent wave part1
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName('big_wave_1')
  mission.enemy:SetAggressive()
  mission.enemy:AttackMoveSelectedUnitsObject(Game:GetEntity('BigWaveTarget1'))
  --sent wave part2
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName('big_wave_2')
  mission.enemy:SetAggressive()
  mission.enemy:AttackMoveSelectedUnitsObject(Game:GetEntity('BigWaveTarget2'))
  mission.bigwave_done = true
  Debug:Log('Big wave has been sent')
end

-- number of path points is important here!!!
-- wave no1 - 6
-- wave no2 - 4
local function CheckBigWaveOnMeetingPositions()
  --[[
  if not wave1onposition then
    mission.enemy:Deselect()
    local x = mission.enemy:SelectUnitsInRadiusOnlyKeyMask(big_wave1_path[6], 1000, 'big_wave_1*')
    if x > 0 then
      wave1onposition = true
      Debug:Log('BigWave Script: Big wave no. 1 on position!!!')
    end
    return
  end
  if not wave2onposition then
    mission.enemy:Deselect()
    local y = mission.enemy:SelectUnitsInRadiusOnlyKeyMask(big_wave2_path[4], 1000, 'big_wave_2*')
    if y > 0 then
      wave2onposition = true
      Debug:Log('BigWave Script: Big wave no. 2 on position!!!')
    end
    return
  end
  ]]--
  -- if ur here, some units have reached the position
  -- can process big wave attack
  Debug:Log('BigWave Script: Going to send coordinated big wave attack!')
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName('big_wave_1*')
  local twn = Game:GetEntity('MyTownhall')
  mission.enemy:SetAggressive()
  --mission.enemy:AttackMoveSelectedUnits(twn)
  mission.enemy:Move(mission.big_meeting1)
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName('big_wave_2*')
  mission.enemy:SetAggressive()
  --mission.enemy:AttackMoveSelectedUnits(twn)
  mission.enemy:Move(mission.big_meeting2)
  Debug:Log('BigWave Script: Big wave has been sent!!!')
  mission.bigwave_done = true
end

local function GenerateBigWave()
-- 1th part
  Debug:Log('Going to generate big wave')
  local j = 0
  for k,v in pairs(big_wave1) do
    j = j + 1
    for i=1,v,1 do
      local name1 = string.format("big_wave_1%.0f%.0f", j, i)
      local unitposition = mission.enemy:GetFreePosition(mission.big_spawn1, 1000, 100)
      mission.enemy:createUnit(unitposition, mission.enemyIndex, 2, k, name1)
    end
  end
  j = 0
  for k,v in pairs(big_wave2) do
    j = j + 1
    for i=1,v,1 do
      local name2 = string.format("big_wave_2%.0f%.0f", j, i)
      local unitposition = mission.enemy:GetFreePosition(mission.big_spawn2, 1000, 100)
      mission.enemy:createUnit(unitposition, mission.enemyIndex, 2, k, name2)
    end
  end
  SendBigWaveToMeeting()
  mission.bigwave_done = true
  --mission.thinkFunction = CheckBigWaveOnMeetingPositions
end

local function init(self)
  Debug:Enable(true)
  Debug:Log('Big Wave Script: Init Started')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex) -- my player
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex) -- enemy player
  mission.timer_default = 2
  mission.timer = 360
  mission.big_spawn1 = Game:GetEntity('BigWavePosition1'):GetPosition()
  mission.big_spawn2 = Game:GetEntity('BigWavePosition2'):GetPosition()
  mission.big_meeting1 = Game:GetEntity('BigWaveMeetingPoint1'):GetPosition()
  mission.big_meeting2 = Game:GetEntity('BigWaveMeetingPoint2'):GetPosition()
  mission.bigwave_target1 = Game:GetEntity('BigWaveTarget1')
  mission.bigwave_target2 = Game:GetEntity('BigWaveTarget2')
  mission.mytownhallattack = Game:GetEntity('MyTownhallAttackPosition')
  mission.base = 100 * mission.player:GetDifficultyCoef()
  mission.mytownhallattackposition = mission.mytownhallattack:GetPosition()
  mission.thinkFunction = SendBigWaveToMeeting
  LoadBigWaveParams()
  --LoadPathParams()
  Debug:Log('Big Wave Script: Init Finished')
  self.init_done = true
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end
  if mission.bigwave_done then
    return
  end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    mission.thinkFunction()
    mission.timer = mission.timer_default
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
     mission.bigwave_done = ar:Read()
	 mission.timer = ar:Read()
     Debug:Log('Script Load End')
	  self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(mission.bigwave_done)
     ar:Write(mission.timer)
     Debug:Log('Script Save End')
   end
end
