-- MAIN SCRIPT
--[[
this scripts checks if player0
has lost or won this mission
]]--

local mission = {}

local function init(self)
  Debug:Log('Main Script: Init Started')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.neutralIndex = 3
  mission.player = Citadels.GetPlayer(mission.playerIndex) -- my player
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex) -- enemy player
  mission.timer_default = 3
  mission.timer = mission.timer_default
  mission.player_townhall = Game:GetEntity('MyTownhall')
  mission.enemy_townhall = Game:GetEntity('EnemyTownhall')
  Debug:Log('Main Script: Script Finished')
  self.init_done = true
end

local function CheckMissionEnd()
  local my_t = Game:GetEntity('MyTownhall')
  if not my_t then
    -- uve lost the game
      Debug:Log("You've lost the game!")

      Citadels.ForceDefeat()
      mission.ended = true
	  Citadels.RemoveEntity(self)
    return
  end
  local enemy_t = Game:GetEntity('EnemyTownhall')
  if not enemy_t then
    --uve won the game
	  mission.player:WinQuest('M06_Destroy')
    --Debug:Log("You've won the game!")
	  -- check if add characters
	  local q1 = mission.player:IsCompletedQuest("M06_ForrestQuest")
	  local q2 = mission.player:IsCompletedQuest("M06_LakeQuest")
	  local q3 = mission.player:IsCompletedQuest("M06_Support")
	  if q1 or q2 or q3 then
		  mission.player:UnlockCharacter("L_Sir-Bedivere")
		  mission.player:UnlockCharacter("L_Sir-Yvain")
	  end
    Citadels.SetAchievementDone(3)
    Citadels.ForceVictory()
    mission.ended = true
	  Citadels.RemoveEntity(self)
    return
  end
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end

  if mission.ended then
    return
  end

  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    CheckMissionEnd()
    mission.timer = mission.timer_default
  end
end
