-- wave no1

local wave = {}
local support = {}
local mission = {}
local id = 1
local save_thinks = {}
local save_thinkCounter = 1

local function LoadWaveParams()
  wave['unit_D_fman_L2'] = 0.04 * mission.base
  wave['unit_D_archer_L2'] = 0.04 * mission.base
end

local function GenerateRandomDelay()
  local r = math.random(mission.delay_min, mission.delay_max)
  Debug:Log('Wave Script No. '..id..': Generating random wave delay: '..r..'s')
  r = r * ( 2 - mission.player:GetDifficultyCoef() )
  return r
end

local function UpdateWave()
  wave['unit_D_fman_L2'] = (wave['unit_D_fman_L2'] + 1) * mission.base * 0.01
  wave['unit_D_archer_L2'] = (wave['unit_D_archer_L2'] + 1) * mission.base * 0.01
  if mission.counter == 4 then
    wave['unit_D_rider_L2'] = 0.03 * mission.base
  end
end

local function CheckSupport()
  if mission.support then
    if not mission.enemy:UnitGroupLives('support') then
      mission.support = false
      mission.player:WinQuest('M06_Support')
      return
    end
    local c = mission.enemy:SelectUnitsInRadiusAddKeyMask(mission.support_target, 1000, 'support')
    if c > 0 then
      mission.support = false
      mission.player:FailQuest('TT_M06_Support')
    end
  end
end

local function GenerateSupport()
  support['unit_D_fman_L2'] = 0.06 * mission.base
  support['unit_D_archer_L2'] = 0.06 * mission.base
  support['unit_D_catapult_L1'] = 0.03 * mission.base
  support['unit_D_rider_L1'] = 0.03 * mission.base
  local spawn = Game:GetEntity('SupportSpawn'):GetPosition()
  local name = 'support'
  for k,v in pairs(support) do
    for i=1,v,1 do
      local unitposition = mission.enemy:GetFreePosition(spawn, 1000, 100)
      mission.enemy:createUnit(unitposition, mission.enemyIndex, 2, k, name)
    end
  end
end

local function SendSupport()
  local name = 'support'
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName(name)
  mission.enemy:SetDefensive()
  mission.enemy:Move(mission.support_meeting, 350)
  mission.support = true
end

local function GenerateWave()
  if mission.counter == 5 then
    SendSupport()
    mission.player:AddQuest('M06_Support', 'side')
  end
  mission.counter = mission.counter + 1
  UpdateWave()
  Debug:Log(string.format('Wave Script No. '..id..': wave '..mission.counter))
  local name = string.format("wave%.0f_%.0f", id, mission.counter)
  for k,v in pairs(wave) do
    for i=1,v,1 do
      local unitposition = mission.enemy:GetFreePosition(mission.spawn, 1000, 100)
      mission.enemy:createUnit(unitposition, mission.enemyIndex, 2, k, name)
    end
  end
  Debug:Log(string.format('Wave '..name..' has been generated' ))
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName(name)
  mission.enemy:SetAggressive()
  mission.enemy:Move(mission.target, 350)
end

local function init(self)
  Debug:Log('Quest 3: Init Start')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex) -- my player
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex) -- enemy player
  mission.timer = 300 * ( 2 - mission.player:GetDifficultyCoef() )
  local spawn = Game:GetEntity('Quest3')
  local target = Game:GetEntity('MyTownhall')
  mission.support_target = Game:GetEntity('SupportTarget'):GetPosition()
  mission.support_meeting = Game:GetEntity('SupportMeetingPoint0'):GetPosition()
  mission.spawn = spawn:GetPosition()
  mission.target = target:GetPosition()
  mission.counter = 0
  mission.delay_min = 180
  mission.delay_max = 300
  mission.base = 100 * mission.player:GetDifficultyCoef()
  if not self.load then
	  mission.player:AddQuest('M06_Destroy', 'main')
	  mission.player:SetQuestPosition('M06_Destroy', 13150,5167)
	end
  LoadWaveParams()
  --GenerateSupport()
  self.init_done = true
  Debug:Log('Quest 3: Init End')
end


function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    GenerateWave()
    CheckSupport()
    mission.timer = GenerateRandomDelay()
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
     mission.counter = ar:Read()
	 mission.support = ar:Read()
	 mission.timer = ar:Read()
     Debug:Log('Script Load End')
	  self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(mission.counter)
     ar:Write(mission.support)
     ar:Write(mission.timer)
     Debug:Log('Script Save End')
   end
end
