local mission = {}
local group_1 = {}
local group_2 = {}
local groups = {group_1, group_2}
local save_thinks = {}
local save_thinkCounter = 1

local function LoadGroupParams()
  group_1['unit_D_archer_L1'] = 0.04  * mission.base
  group_1['unit_D_fman_L1'] = 0.04  * mission.base
  group_2['unit_D_archer_L2'] = 0.04  * mission.base
  group_2['unit_D_fman_L2'] = 0.04  * mission.base
  attack1 = Game:GetEntity('AttackPosition1'):GetPosition()
  attack2 = Game:GetEntity('AttackPosition2'):GetPosition()
end

local function CheckQuestRun()
  local g1 = mission.enemy:UnitGroupLives('group_1')
  local g2 = mission.enemy:UnitGroupLives('group_2')
  local t = Game:GetEntity('P3-fakeThall-0')
  --local f1 = Game:GetEntity('P3-farm-L1-0')
  --local f2 = Game:GetEntity('P3-farm-L1-1')
  
  if not t then
    mission.player:FailQuest('M06_LakeQuest')
    mission.enemy:Deselect()
    mission.enemy:SelectUnitsByName('group_1')
    mission.enemy:SelectUnitsByName('group_2')
    mission.enemy:Move(mission.home, 350)
    mission.script_done = true
  end
  
  if not g1 and not g2 then
    mission.player:WinQuest('M06_LakeQuest')
    missiom.player:AddResource(0, 500)
    mission.script_done = true
  end
  
end

local function CheckQuestStart()
  if mission.player:SomeUnitsInRadius(mission.trigger, mission.radius, '*') then
    local msg = 'The village expects the enemy soon! Help these poor peaple.'
    --mission.player:PrintInfoMessage(msg)
    mission.timer = mission.timer_patrol_delay
	
    mission.player:AddQuest('M06_LakeQuest', 'side')
	mission.player:SetQuestPosition('M06_LakeQuest', -7844,15424)
	
    mission.enemy:Deselect()
    mission.enemy:SelectUnitsByName('group_1')
    mission.enemy:SetAggressive()
    mission.enemy:Move(attack1, 350)
    mission.enemy:Deselect()
    mission.enemy:SelectUnitsByName('group_2')
    mission.enemy:SetAggressive()
    mission.enemy:Move(attack2, 350)
    mission.enemy:Deselect()
	save_thinkCounter = 4
    mission.thinkFunction = CheckQuestRun
  end
end

local function GeneratePatrol()
  for i=1,2,1 do
    local patrol = groups[i]
    local name = 'group_'..i
    for k,v in pairs(patrol) do
      for j=1,v,1 do
        local unitposition = mission.enemy:GetFreePosition(mission.p0, 1000, 100)
        mission.enemy:createUnit(unitposition, 1, 2, k, name)
      end
    end
    mission.enemy:Deselect()
    mission.enemy:SelectUnitsByName(name)
    mission.enemy:SetDefensive()
    mission.enemy:Move(mission.p[i])
  end
end

function OnThink(self)
	if not mission.init_done then
    Debug:Log('Quest 2: Init Start')
    mission.player = Citadels.GetPlayer(0)
    mission.enemy = Citadels.GetPlayer(1)
    mission.p0 = Game:GetEntity('Position0'):GetPosition()
    mission.p1 = Game:GetEntity('Position1'):GetPosition()
    mission.p2 = Game:GetEntity('Position2'):GetPosition()
    mission.home = Game:GetEntity('SupportTarget'):GetPosition()
    mission.trigger = Game:GetEntity('Quest2'):GetPosition()
    mission.p = {mission.p1, mission.p2}
    mission.radius = 2000
    mission.timer_default = 2
	mission.timer = mission.timer_default
	mission.base = 100 * mission.player:GetDifficultyCoef()
	if not self.load then
	    mission.timer_patrol_delay = 10
		save_thinkCounter = 1
		mission.thinkFunction = CheckQuestStart
	end
    LoadGroupParams()
    GeneratePatrol()
    Debug:Log('Quest 2: Init End')
    mission.init_done = true
  end
  if mission.script_done then
    return
  end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    mission.timer = mission.timer_default
    mission.thinkFunction()
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
     mission.script_done = ar:Read()
	 mission.timer_patrol_delay = ar:Read()
	 save_thinkCounter = ar:Read()
	 save_thinks[1] = CheckQuestStart
	 save_thinks[2] = CheckQuestRun
	 mission.thinkFunction = save_thinks[save_thinkCounter]
     Debug:Log('Script Load End')
	  self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(mission.script_done)
     ar:Write(mission.timer_patrol_delay)
     ar:Write(save_thinkCounter)
     Debug:Log('Script Save End')
   end
end
