--[[
script generates waves in the enemy castle
]]--

local patrol_1 = {}
local patrol_2 = {}
local patrol_3 = {}
local patrols = {patrol_1, patrol_2, patrol_3}
local mission = {}
local path = {}
local save_thinks = {}
local save_thinkCounter = 1

local function LoadPatrolParams()
  path[0] = Game:GetEntity('PatrolPath1'):GetPosition()
  path[1] = Game:GetEntity('PatrolPath2'):GetPosition()
  patrol_1['unit_D_archer_L2'] = 0.03 * mission.base
  patrol_1['unit_D_fman_L2'] = 0.03 * mission.base
  patrol_2['unit_D_archer_L2'] = 0.05 * mission.base
  patrol_2['unit_D_fman_L2'] = 0.05 * mission.base
  patrol_3['unit_D_archer_L3'] = 0.06 * mission.base
  patrol_3['unit_D_rider_L1'] = 0.03 * mission.base
end

local function GeneratePatrol()
  for i=1,3,1 do
    local patrol = patrols[i]
    local name = 'patrol_'..i
    for k,v in pairs(patrol) do
      for j=1,v,1 do
      local unitposition = mission.enemy:GetFreePosition(mission.p0, 1000, 100)
      mission.enemy:createUnit(unitposition, 1, 2, k, name)
      end
    end
    mission.enemy:Deselect()
    mission.enemy:SelectUnitsByName(name)
    mission.enemy:SetDefensive()
    mission.enemy:Move(mission.p[i])
  end
end

local function RewardQuest()
  --mission.player:PrintInfoMessage('You bring safety to the village!')
  --mission.player:PrintInfoMessage('Quest 1 finished. Enjoy your reward.')
  mission.player:WinQuest('M06_ForrestQuest')
  mission.player:AddResource(1, 500)
  mission.script_done = true
end

local function CheckQuestRun()
  local name = 'patrol_'..mission.patrol_counter
  if not mission.enemy:UnitGroupLives(name) then
    mission.patrol_counter = mission.patrol_counter + 1
    if mission.patrol_counter > 3 then
      RewardQuest()
      mission.script_done = true
      return
    end
    name = 'patrol_'..mission.patrol_counter
    mission.enemy:Deselect()
    mission.enemy:SelectUnitsByName(name)
    mission.enemy:SetAggressive()
    mission.enemy:Move(path[0], 500)
    return
  end
  local position0 = path[0]
  local position1 = path[1]
  mission.enemy:Deselect()
  local c = mission.enemy:SelectUnitsInRadiusOnlyKeyMask(position0, mission.radius, name)
  if c > 0 then
    mission.enemy:Move(position1, 300)
  end
  mission.enemy:Deselect()
  local d = mission.enemy:SelectUnitsInRadiusOnlyKeyMask(position1, mission.radius, name)
  if d > 0 then
    mission.enemy:Move(position0, 300)
  end
end

local function CheckQuestStart()
  if mission.player:SomeUnitsInRadius(mission.trigger, mission.radius, '*') then
    mission.enemy:Deselect()
    mission.enemy:SelectUnitsByName('patrol_1')
    mission.enemy:SetAggressive()
    mission.enemy:Move(path[0], 400)
    mission.player:AddQuest('M06_ForrestQuest', 'side')
	save_thinkCounter = 2
    mission.thinkFunction = CheckQuestRun
  end
end

function OnThink(self)
	if not mission.init_done then
    Debug:Log('Quest 1: Init Start')
    mission.player = Citadels.GetPlayer(0)
    mission.enemy = Citadels.GetPlayer(1)
    mission.p0 = Game:GetEntity('PatrolPosition0'):GetPosition()
    mission.p1 = Game:GetEntity('PatrolPosition1'):GetPosition()
    mission.p2 = Game:GetEntity('PatrolPosition2'):GetPosition()
    mission.p3 = Game:GetEntity('PatrolPosition3'):GetPosition()
    mission.p = {mission.p1, mission.p2, mission.p3}
    mission.trigger = Game:GetEntity('Quest1'):GetPosition()
    mission.radius = 1000
    mission.timer_default = 2
    mission.timer = mission.timer_default
	mission.base = 100 * mission.player:GetDifficultyCoef()
	if not self.load then
		mission.patrol_counter = 1
		save_thinkCounter = 1
		mission.thinkFunction = CheckQuestStart
	end
    LoadPatrolParams()
    GeneratePatrol()
    Debug:Log('Quest 1: Init End')
    mission.init_done = true
  end
  if mission.script_done then
    return
  end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    mission.thinkFunction()
    mission.timer = mission.timer_default
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
     mission.script_done = ar:Read()
	 mission.patrol_counter = ar:Read()
	 save_thinkCounter = ar:Read()
	 save_thinks[1] = CheckQuestStart
	 save_thinks[2] = CheckQuestRun
	 mission.thinkFunction = save_thinks[save_thinkCounter]
     Debug:Log('Script Load End')
	  self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(mission.script_done)
     ar:Write(mission.patrol_counter)
     ar:Write(save_thinkCounter)
     Debug:Log('Script Save End')
   end
end

