local quest = {}
local wave = {}

local function LoadWaveParams()
  wave['unit_D_archer_L1'] = 0.03 * quest.base
end

local function UpdateWaveParams()
  wave['unit_D_archer_L1'] = (3 + quest.wave_counter) * quest.base * 0.01
end

local function GenerateRandomDelay()
  local r = quest.timer_min + (math.random() * 3) --generates delay <quest.timer_min,5min>
  r = r * 60 -- give me seconds
    r = r * ( 2 - quest.player:GetDifficultyCoef() )
  return r
end

local function GenerateWaveAI()
  quest.wave_counter = quest.wave_counter + 1
  UpdateWaveParams()
  Debug:Log('QUEST 2: Generating AI'..quest.wave_counter..'. wave')
  for prefab,ammount in pairs(wave) do
    quest.enemy:AttackGroupAdd(prefab, ammount)
  end
  Debug:Log('QUEST 2: AI Wave no. '..quest.wave_counter..' has been sent to your townhall!')
  quest.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  quest.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  quest.enemy:AttackGroupCommit(1, quest.spawn_position,20)
  --quest.enemy:Move(quest.target_position)
end

local function GenerateWave()
  quest.wave_counter = quest.wave_counter + 1
  UpdateWaveParams()
  Debug:Log('QUEST 2: Generating '..quest.wave_counter..'. wave')
  for k,v in pairs(wave) do
    for i=1,v,1 do
      local name = string.format('quest2_wave%.0f_%.0f', quest.wave_counter, i)
      local unitposition = quest.enemy:GetFreePosition(quest.spawn_position, 1000, 100)
      quest.enemy:createUnit(unitposition, quest.enemyIndex, 2, k, name)
    end
  end
  Debug:Log('QUEST 2: Wave no. '..quest.wave_counter..' has been sent to your townhall!')
  quest.enemy:Deselect()
  quest.enemy:SelectUnitsByName(string.format("quest2_wave%.0f_*", quest.wave_counter))
  quest.enemy:SetAggressive()
  quest.enemy:Move(quest.target_position)

end

local function init(self)
  Debug:Log("QUETS 2: INIT STARTED")
  quest.playerIndex = 0
  quest.enemyIndex = 1
  quest.player = Citadels.GetPlayer(0)
  quest.enemy = Citadels.GetPlayer(1)
  quest.spawn = Game:GetEntity('quest2_spawnposition')
  quest.target = Game:GetEntity('MyTownhall')
  quest.spawn_position = Game:GetEntity('quest2_spawnposition'):GetPosition()
  quest.target_position = Game:GetEntity('MyTownhall'):GetPosition()
   quest.init_timer = 500 * ( 2 - quest.player:GetDifficultyCoef() )
	quest.timer_min = 3
	quest.base = 100 * quest.player:GetDifficultyCoef()
  if not self.load then
    quest.wave_counter = 0
    quest.timer = quest.init_timer
    quest.player:AddQuest('M04_Archery', 'side')
    quest.player:SetQuestPosition('M04_Archery', -15140,-15420)
  end
  math.randomseed(os.time())
  LoadWaveParams()
  Debug:Log('QUEST 2: INIT FINISHED')
  self.init_done = true
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end

  local dt = Timer:GetTimeDiff()
  quest.timer = quest.timer - dt
  if quest.timer <= 0 then
    --GenerateWave()
    GenerateWaveAI()
    quest.timer = GenerateRandomDelay()
  end
end

function OnBeforeDeath(self)
  quest.player:WinQuest('M04_Archery')
  quest.player:AddResource(3, 500)
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('Script Load Start')
     --G.captured = ar:Read()
	quest.wave_counter = ar:Read()
	quest.timer = ar:Read()
     Debug:Log('Script Load End')
	 self.load = true
   else
     Debug:Log('Script Save Start')
     --ar:Write(G.captured)
	 	ar:Write(quest.wave_counter)
		ar:Write(quest.timer)
     Debug:Log('Script Save End')
   end
end
