local quest = {}
local wave = {}

local function LoadWaveParams()
  wave['unit_L_fman_L1'] = 0.03 * quest.base
end

local function UpdateWaveParams()
  wave['unit_L_fman_L1'] = (2 + quest.wave_counter) * quest.base * 0.01
end

local function GenerateRandomDelay()
  local r = quest.timer_min + (math.random() * 3) --generates delay 3 -> 5mim
  r = r * 60 -- give me seconds
  r = r * ( 2 - quest.player:GetDifficultyCoef() )
  return r
end

local function GenerateWaveAI()
  quest.wave_counter = quest.wave_counter + 1
  UpdateWaveParams()
  Debug:Log('QUEST 1: Generating AI'..quest.wave_counter..'. wave')
  for prefab,ammount in pairs(wave) do
    quest.enemy:AttackGroupAdd(prefab, ammount)
  end
  Debug:Log('QUEST 1: AI Wave no. '..quest.wave_counter..' has been sent to your townhall!')
  quest.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  quest.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  quest.enemy:AttackGroupCommit(1, quest.spawn_position,20)
  --quest.enemy:Move(quest.target_position)
end

local function GenerateWave()
  quest.wave_counter = quest.wave_counter + 1
  UpdateWaveParams()
  Debug:Log('QUEST 1: Generating '..quest.wave_counter..'. wave')
  for k,v in pairs(wave) do
    for i=1,v,1 do
      local name = string.format('quest1_wave%.0f_%.0f', quest.wave_counter, i)
      local unitposition = quest.enemy:GetFreePosition(quest.spawn_position, 1000, 100)
      quest.enemy:createUnit(unitposition, quest.enemyIndex, 2, k, name)
    end
  end
  Debug:Log('QUEST 1: Wave no. '..quest.wave_counter..' has been sent to your townhall!')
  quest.enemy:Deselect()
  quest.enemy:SelectUnitsByName(string.format("quest1_wave%.0f_*", quest.wave_counter))
  quest.enemy:SetAggressive()
  quest.enemy:Move(quest.target_position)

end

local function init(self)
  Debug:Log("QUEST 1: INIT STARTED")
  quest.playerIndex = 0
  quest.enemyIndex = 1
  quest.player = Citadels.GetPlayer(0)
  quest.enemy = Citadels.GetPlayer(1)
  quest.spawn = Game:GetEntity('quest1_spawnposition')
  quest.target = Game:GetEntity('MyTownhall')
  quest.spawn_position = quest.spawn:GetPosition()
  quest.target_position = quest.target:GetPosition()
  quest.timer_min = 4
  quest.init_timer = 600 * ( 2 - quest.player:GetDifficultyCoef() )
  quest.base = 100 * quest.player:GetDifficultyCoef()
  if not self.load then
	quest.wave_counter = 0
	quest.timer = quest.init_timer
	quest.player:AddQuest('M04_Barracks', 'side')
  quest.player:SetQuestPosition('M04_Barracks', 18800,19627)
  end
  math.randomseed(os.time())
  LoadWaveParams()
  Debug:Log('QUEST 1: INIT FINISHED')
  self.init_done = true
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end

  local dt = Timer:GetTimeDiff()
  quest.timer = quest.timer - dt
  if quest.timer <= 0 then
    --GenerateWave()
    GenerateWaveAI()
    quest.timer = GenerateRandomDelay()
  end
end

function OnBeforeDeath(self)
  quest.player:WinQuest('M04_Barracks')
  quest.player:AddResource(2, 500)
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('Script Load Start')
     --G.captured = ar:Read()
	quest.wave_counter = ar:Read()
	quest.timer = ar:Read()
     Debug:Log('Script Load End')
	 self.load = true
   else
     Debug:Log('Script Save Start')
     ar:Write(quest.wave_counter)
	 ar:Write(quest.timer)
     Debug:Log('Script Save End')
   end
end
