local quest = {}
local wave = {}
local support = {}
local lastwave = {}

local function LoadWaveParams()
  wave['unit_D_archer_L2'] = quest.base * 0.03
  wave['unit_D_fman_L2'] = quest.base * 0.03

  support['unit_L_archer_L1'] = 15
  support['unit_L_fman_L1'] = 20

  lastwave['unit_D_archer_L2'] = 25
  lastwave['unit_D_fman_L2'] = 25
end

local function UpdateWaveParams()
  wave['unit_D_archer_L2'] = (2 + quest.wave_counter) * quest.base * 0.01
  wave['unit_D_fman_L2'] = (2 + quest.wave_counter) * quest.base * 0.01
end

local function SpawnSupport()
  local s = Game:GetEntity('SupportArmySpawn'):GetPosition()
  local t = Game:GetEntity('SupportArmyAttack'):GetPosition()
  for k,v in pairs(support) do
    for i=1,v,1 do
      local unitposition = quest.support:GetFreePosition(s, 1000, 100)
      quest.support:createUnit(unitposition, supportIndex, 2, k, 'suppportArmy')
    end
  end
  quest.support:Deselect()
  quest.support:SelectUnitsByName('suppportArmy')
  quest.support:SetAggressive()
  quest.support:Move(t, 350)
  quest.player:EditFowIndex(3, true)
end

local function SpawnLastWave()
  local s = Game:GetEntity('WaveSpawn'):GetPosition()
  local t = Game:GetEntity('SupportArmyAttack'):GetPosition()
  for k,v in pairs(lastwave) do
    for i=1,v,1 do
      local unitposition = quest.enemy:GetFreePosition(s, 1000, 100)
      quest.enemy:createUnit(unitposition, 1, 2, k, 'lastWave')
    end
  end
  quest.enemy:Deselect()
  quest.enemy:SelectUnitsByName('lastWave')
  quest.enemy:SetAggressive()
  quest.enemy:Move(t, 370)
end

local function GenerateRandomDelay()
  local r = quest.timer_min + (math.random() * 2) --generates delay <quest.timer_min,5min>
  r = r * 60 -- give me seconds
  return r
end

local function ThinkFunctionSupport()
  local l = quest.support:CheckUnitsCountKey('suppportArmy', 10, supportIndex)
  if not l then
    quest.player:EditFowIndex(3, false)
	  local ent1 = Game:GetEntity('quest2_archery_D_L1')
	  local ent2 = Game:GetEntity('quest1_barracks_D_L1')
	  if not ent1 and not ent2 then
		  quest.player:UnlockCharacter("L_Sir-Balin")
	  end
	  Citadels.SetAchievementDone(2)
    Citadels.ForceVictory()
  end
  quest.timer = 5
end

local function GenerateWave()
  quest.wave_counter = quest.wave_counter + 1
  UpdateWaveParams()
  --Debug:Log('QUEST 2: Generating '..quest.wave_counter..'. wave')
  for k,v in pairs(wave) do
    for i=1,v,1 do
      local name = string.format('quest2_wave%.0f_%.0f', quest.wave_counter, i)
      local unitposition = quest.enemy:GetFreePosition(quest.spawn_position, 1000, 100)
      quest.enemy:createUnit(unitposition, quest.enemyIndex, 2, k, name)
    end
  end
  --Debug:Log('QUEST 2: Wave no. '..quest.wave_counter..' has been sent to your townhall!')
  quest.enemy:Deselect()
  quest.enemy:SelectUnitsByName(string.format("quest2_wave%.0f_*", quest.wave_counter))
  quest.enemy:SetAggressive()
  quest.enemy:SetAggressive()
  quest.enemy:AttackMoveSelectedUnitsObject(Game:GetEntity('MyTownhall'))
  --quest.enemy:Move(quest.target_position, 350)
  if quest.wave_counter > 8 then
      quest.player:WinQuest('M04_Waves')
      SpawnLastWave()
      SpawnSupport()
      quest.thinkFunction = ThinkFunctionSupport
      quest.timer = 5
      --quest.thinkFunction = function () end
  end
end

local function ThinkFunctionWaves()
  quest.timer = GenerateRandomDelay()
  GenerateWave()
end

local function init(self)
  Debug:Log("QUETS 2: INIT STARTED")
  quest.playerIndex = 0
  quest.enemyIndex = 1
  supportIndex = 3
  quest.player = Citadels.GetPlayer(0)
  quest.enemy = Citadels.GetPlayer(1)
  quest.support = Citadels.GetPlayer(3)
  quest.spawn = Game:GetEntity('WaveSpawn')
  quest.target = Game:GetEntity('MyTownhall')
  quest.spawn_position = quest.spawn:GetPosition()
  quest.target_position = quest.target:GetPosition()
  quest.init_timer = 450 * ( 2 - quest.player:GetDifficultyCoef() )
  quest.timer = quest.init_timer
  quest.timer_min = 4
  quest.base = 100 * quest.player:GetDifficultyCoef()
  math.randomseed(os.time())
  LoadWaveParams()
  quest.thinkFunction = ThinkFunctionWaves
  if not self.load then
	Debug:Log('You should not see this when load game')
    self.init_done = true
    quest.timer = quest.init_timer
    quest.wave_counter = 0
    quest.player:AddQuest('M04_Waves', 'main')
  end
  Debug:Log('QUEST 2: INIT FINISHED')
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end

  local dt = Timer:GetTimeDiff()
  quest.timer = quest.timer - dt
  if quest.timer <= 0 then
    quest.thinkFunction()
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     --local s = ar:Read()
     Debug:Log('Script Load Start')
	 quest.wave_counter = ar:Read()
	 quest.timer = ar:Read()
	 self.init_done = ar:Read()
	 Debug:Log('Script Load End')
    self.load = true
   else
	Debug:Log('Script Save Start')
	 ar:Write(quest.wave_counter)
	 ar:Write(quest.timer)
	 ar:Write(self.init_done)
    Debug:Log('Script Save End')
   end
end
