--[[
local from = 1
local to = 2

local function CheckPatrolPosition(self)
  local point = self.p[self.p_check]
  local c = self.enemy:SomeUnitsInRadiusOnlyKey(point, 500, 'wave_unit')
  if c then
    Debug:Log('Patrol reached meeting point...')
    self.p_check = self.p_check + 1
    if self.p_check > 2 then
      self.script_done = true
    end
    self.enemy:Deselect()
    self.enemy:SelectUnitsByName('wave_unit') 
    self.enemy:Move(self.p[self.p_check], 350)
  end
end

function OnThink(self)
  if self.script_done then
    return
  end

  if not self.init_done then
    self.enemy = Citadels.GetPlayer(1)
    self.timer_default = 1
    if not self.load then
		self.script_done = false
      self.timer = 1
      self.p_check = 0
    end
    self.p = {}
    self.p[0] = Game:GetEntity('wave_node_1'):GetPosition()
    self.p[1] = Game:GetEntity('wave_node_2'):GetPosition()
    self.p[2] = Game:GetEntity('wave_node_3'):GetPosition()
    self.init_done = true
  end
  
  local dt = Timer:GetTimeDiff()
  self.timer = self.timer - dt
  if self.timer <= 0 then
    self.timer = self.timer_default
    CheckPatrolPosition(self)
  end
end
]]--

local from = 2
local to = 3

function OnThink(self)
  if not self.init_done then
	  self.player1 = Citadels.GetPlayer(1)
    self.timer_default = 1
    self.timer = self.timer_default
    local nameFrom = 'wave_node_'..from
    local nameTo = 'wave_node_'..to
    self.from = Game:GetEntity(nameFrom):GetPosition()
    self.to = Game:GetEntity(nameTo):GetPosition()
    self.init_done = true
  end
  local dt = Timer:GetTimeDiff()
  self.timer = self.timer - dt
  if self.timer <= 0 then
    local c = self.player1:SelectUnitsInRadiusOnlyKeyMask(self.from, 500, 'wave_unit')
    if c > 5 then
      self.player1:Deselect()
      self.player1:SelectUnitsByName('wave_unit')
      self.player1:SetAggressive()
      self.player1:Move(self.to, 350)
      Citadels.RemoveEntity(self)
    end
    self.timer = self.timer_default
  end
end
