local mission = {}

local function init(self)
  Debug:Log('Main Script: Init Start')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex) -- my player
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex) -- enemy player
  if not self.load then
	    G.captured = false
     mission.script_done = false
  end
  mission.timer_default = 3
  mission.timer = mission.timer_default
  self.init_done = true
  Debug:Log('Main Script: Init End')
end

local function CheckMissionEnd()
  -- defeat

  local t2 = Game:GetEntity('capture1')
  if not t2 then
    Debug:Log('Your townhall has been destoyed!')
    Citadels.ForceDefeat()
    mission.script_done = true
  end
end

function OnThink(self)
  if not self.init_done then
    init(self)
  end
  
  local ar = Game:GetEntity('Arthur')
  if not ar then
    Debug:Log('Arthur died!')
    Citadels.ForceDefeat()
    mission.script_done = true
  end
  
  if not G.captured or mission.script_done then
    return
  end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    mission.timer = mission.timer_default
    CheckMissionEnd()
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('Script Load Start')
     --G.captured = ar:Read()
     G.captured = ar:Read()
     mission.script_done = ar:Read()
     Debug:Log('Script Load End')
	 self.load = true
   else
     Debug:Log('Script Save Start')
     --ar:Write(G.captured)
     ar:Write(G.captured)
     ar:Write(mission.script_done)
     Debug:Log('Script Save End')
   end
end
