--[[
handles script to get excalibur
]]--

local mission = {}
local patrol = {}
local save_thinks = {} 

local function EmptyThink()
--empty
end

local function SendWave()
   local p1 = Game:GetEntity('wave_node_1'):GetPosition()
   local p2 = Game:GetEntity('wave_node_2'):GetPosition()
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName('wave_unit')
  mission.enemy:SetAggressive()
  mission.enemy:Move(p1, 350)
  mission.script_done = true
  mission.thinkCounter = 4
  mission.thinkFunction = EmptyThink
  Debug:Log('Excalibur script has finished')
end

local function CheckWarning1()
  local c = mission.player:SomeUnitsInRadius(mission.warning1, mission.radius1, '*')
  if c then
    -- get info to player!!!
    local m = 'There is danger behind the bridge! Find another way!'
    mission.player:AddQuest('M02_Warning1', 'side')
    --Debug:Log(m)
    --mission.player:PrintInfoMessage(m)
    mission.w1_done = true
  end
end

local function SendWarning2Group()
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName('warning_2_group')
  mission.enemy:SetAggressive()
  local ent = Game:GetEntity('path_node_1'):GetPosition()
  mission.enemy:Move(ent, 350)
end

local function CheckWarning2()
  local c = mission.player:SomeUnitsInRadius(mission.warning2, mission.radius2, '*')
  if c then
    -- get info to player!!!
    local m = 'An enemy patrol is comming. Find the place to hide!'
    mission.player:WinQuest('M02_Warning1')
    mission.player:AddQuest('M02_Warning2', 'side')
    --Debug:Log(m)
    --mission.player:PrintInfoMessage(m)
    G.patrol_allowed = true
    mission.w2_done = true
    SendWarning2Group()
  end
end

local function CheckOwnership()
	Debug:Log('Checking ownership...')
  local c = mission.player:SomeUnitsInRadiusOnlyKey(mission.capture, mission.capture_radius, 'Arthur')
  local d = mission.enemy:SomeUnitsInRadius(mission.capture, mission.capture_radius, '*')
  -- d condition is exculded for now!!!!!!!!!
  if c then
	-- stop neutral ai bot
	mission.neutral:AIStopAiBot(true)
	local r = mission.neutral:AIRemoveAIBot()
	if not r then
		Debug:Log('lua: Failed to remove AI BOT component!')
	end
    for i=1,15,1 do
      local name = 'capture'..i
      local ent = Game:GetEntity(name)
      if not ent then
        Debug:Log('Cannot find '..name)
      end
      mission.player:SwitchOwnership(ent, mission.playerIndex)
    end
    mission.player:SwitchOwnershipInRadius(mission.capture, mission.capture_radius, mission.neutralIndex, mission.playerIndex)
    local t = Game:GetEntity('capture1')
    --mission.player:SetTownhallScript(t)
    
    --mission.timer_default = mission.timer_wave
    --mission.timer = mission.timer_default
    G.captured = true
	mission.player:WinQuest('M02_Trust')
    local m = 'You have captured new village!'
    --mission.player:PrintInfoMessage(m)
    --mission.player:PrintInfoMessage('Now expect the enemy!')
    mission.timer_default = mission.wave_delay
    mission.thinkCounter = 3
    mission.thinkFunction = SendWave 
  end
end

local function CheckExcalibur()
  --local c = mission.player:SomeUnitsInRadius(mission.excalibur, mission.radius, '*')
  local ex = Game:GetEntity('ExcaliburSword')
  if not ex then
    mission.thinkCounter = 2
    mission.thinkFunction = CheckOwnership
    mission.ex_done = true
  end
end

local function CheckAllDead()
 local c = mission.player:UnitsNumber('*')
 if c == 0 then
  Citadels.ForceDefeat()
 end
end

local function CheckWarnings()
  CheckAllDead()
  if not mission.w1_done then CheckWarning1() end
  if not mission.w2_done then CheckWarning2() end
  if not mission.ex_done then CheckExcalibur() end
  local art = Game:GetEntity('Arthur')
  if not art then
    Citadels.ForceDefeat()
  end
end

local function LoadEntities(self)
  mission.warning1 = Game:GetEntity('WarningPosition1'):GetPosition()
  mission.warning2 = Game:GetEntity('WarningPosition2'):GetPosition()
  mission.radius1 = 1500
  mission.radius2 = 2000
  mission.capture = Game:GetEntity('CapturePosition'):GetPosition()
  mission.radius = 1000
  mission.target = Game:GetEntity('WaveTarget'):GetPosition()
  mission.capture_radius = 1000
  mission.warning_1 = Game:GetEntity('WarningGroup1'):GetPosition()
  mission.warning_2 = Game:GetEntity('WarningGroup2'):GetPosition()
end

local function SaveThinks()
  save_thinks[1] = CheckWarnings
  save_thinks[2] = CheckOwnership
  save_thinks[3] = SendWave
  save_thinks[4] = EmptyThink
end

local function init(self)
  Debug:Log("Excalibur Script: Init Started")
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.neutralIndex = 2
  mission.player = Citadels.GetPlayer(mission.playerIndex) -- my player
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex) -- enemy player
  mission.neutral = Citadels.GetPlayer(mission.neutralIndex)
  LoadEntities(self)
  mission.player:SetUnitNameToUnit(Game:GetEntity('Arthur'), 'unit_L_kingarthur_L1')
  SaveThinks()
  if not self.load then
    Debug:Log('Warning: You cannot see this if LOAD GAME')
	  mission.script_done = false
	  G.patrol_allowed = false
	  mission.w1_done = false
    mission.w2_done = false
    mission.ex_done = false
	  G.captured = false
    mission.timer_default = 1
    mission.timer = mission.timer_default
    mission.timer_wave = 60
    mission.wave_delay = 60
    G.captured = false
    mission.player:AddQuest('M02_FindSword', 'main')
  	mission.player:AddQuest('M02_Destroy', 'main')
    mission.player:SetQuestPosition('M02_Destroy', -12580,10383)

    mission.thinkCounter = 1
    mission.thinkFunction = CheckWarnings
  end
  self.init_done = true
  Debug:Log("Excalibur Script: Init Finished")
end

function OnThink(self)
  if not self.init_done then
    init(self)
  end
  if mission.script_done then
    return
  end

  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    mission.timer = mission.timer_default
    mission.thinkFunction()
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
     mission.script_done = ar:Read()
     G.patrol_allowed = ar:Read()
     mission.w1_done = ar:Read()
     mission.w2_done = ar:Read()
     mission.ex_done = ar:Read()
     G.captured = ar:Read()
     mission.timer_default  = ar:Read()
     mission.timer = ar:Read()
     mission.timer_wave = ar:Read()
     mission.wave_delay = ar:Read()
     mission.thinkCounter  = ar:Read()
	 SaveThinks()
     mission.thinkFunction = save_thinks[mission.thinkCounter] 
     Debug:Log('Script Load End')
	  self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(mission.script_done)
     ar:Write(G.patrol_allowed)
     ar:Write(mission.w1_done)
     ar:Write(mission.w2_done)
     ar:Write(mission.ex_done)
     ar:Write(G.captured)
     ar:Write(mission.timer_default)
     ar:Write(mission.timer)
     ar:Write(mission.timer_wave)
     ar:Write(mission.wave_delay)
     ar:Write(mission.thinkCounter)
     Debug:Log('Script Save End')
   end
end