local mission = {}

local function LoadCaptureParams()
  mission.capture2 = Game:GetEntity('CapturePosition2'):GetPosition()
  mission.capture3 = Game:GetEntity('CapturePosition3'):GetPosition()
  mission.capture4 = Game:GetEntity('CapturePosition4'):GetPosition()
  mission.radius2 = 5200
  mission.radius3 = 5100
  mission.radius4 = 2200
end

local function CheckCapture3()
  local my = mission.player:UnitsInRadiusNumberByKey(mission.capture4, mission.radius4, '*')
  local their = mission.enemy:UnitsInRadiusNumberByKey(mission.capture4, mission.radius4, '*')
  --their = their * 2
  if my > their then
    Debug:Log('Enemy Fortification has been captured')
	local t = Game:GetEntity('P3-thallT-L3-0')
	if not t then
		Debug:Log('LUA ERROR: cannot find P3-thallT-L3-0')
	else
		mission.player:SwitchOwnership(t, mission.playerIndex)
	end
	
	  for i=1,29,1 do
      local name = 'XCapture'..i
      local ent = Game:GetEntity(name)
      if not ent then
        Debug:Log('Cannot find X'..name)
      else
		mission.player:SwitchOwnership(ent, mission.playerIndex)
	  end
    end
    --mission.player:SwitchOwnershipInRadius(mission.capture4, mission.radius4, mission.alieIndex, mission.playerIndex)
    mission.player:WinQuest('M10_Town3')
    G.capture3_done = true
  end
end

local function init(self)
  Debug:Log('Capture Script: Init Started')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.alieIndex = 3
  mission.player = Citadels.GetPlayer(mission.playerIndex)
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex)
  if not mission.player or not mission.enemy then
    Debug:Log('Cannot find players')
    return
  end
  mission.timer_default = 3
  mission.timer = mission.timer_default
  LoadCaptureParams()
  self.init_done = true
  Debug:Log('Capture Script: Init Finished')
end

function OnThink(self)
	  -- do init first
  if not self.init_done then
    init(self)
  end
  
  if G.capture3_done then
    return
  end
  
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    CheckCapture3()
    mission.timer = mission.timer_default
  end
end
